"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSafePaletteParams = getSafePaletteParams;
var _coloring = require("@kbn/coloring");
var _shared_components = require("../../shared_components");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSafePaletteParams(paletteService, currentData, accessor, activePalette) {
  var _minMaxByColumnId$get;
  if (currentData == null || accessor == null) {
    return {
      displayStops: [],
      activePalette
    };
  }
  const finalActivePalette = activePalette !== null && activePalette !== void 0 ? activePalette : {
    type: 'palette',
    name: _constants.DEFAULT_PALETTE_NAME,
    accessor
  };
  const minMaxByColumnId = (0, _shared_components.findMinMaxByColumnId)([accessor], currentData);
  const currentMinMax = (_minMaxByColumnId$get = minMaxByColumnId.get(accessor)) !== null && _minMaxByColumnId$get !== void 0 ? _minMaxByColumnId$get : {
    max: Number.NEGATIVE_INFINITY,
    min: Number.POSITIVE_INFINITY
  };

  // need to tell the helper that the colorStops are required to display
  return {
    displayStops: (0, _coloring.applyPaletteParams)(paletteService, finalActivePalette, currentMinMax),
    currentMinMax,
    activePalette: finalActivePalette
  };
}