"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizeAggBasedVisAction = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visualizeAggBasedVisAction = application => (0, _public.createAction)({
  type: _public2.ACTION_CONVERT_TO_LENS,
  id: _public2.ACTION_CONVERT_AGG_BASED_TO_LENS,
  getDisplayName: () => _i18n.i18n.translate('xpack.lens.visualizeAggBasedLegend', {
    defaultMessage: 'Visualize agg based chart'
  }),
  isCompatible: async () => !!application.capabilities.visualize_v2.show,
  execute: async context => {
    const table = Object.values(context.layers);
    const payload = {
      ...context,
      layers: table,
      isVisualizeAction: true
    };
    application.navigateToApp('lens', {
      state: {
        type: _public2.ACTION_CONVERT_TO_LENS,
        payload,
        originatingApp: _i18n.i18n.translate('xpack.lens.AggBasedLabel', {
          defaultMessage: 'aggregation based visualization'
        })
      }
    });
  }
});
exports.visualizeAggBasedVisAction = visualizeAggBasedVisAction;