"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocumentationSections = getDocumentationSections;
exports.getFunctionSignatureLabel = getFunctionSignatureLabel;
exports.getHelpTextContent = getHelpTextContent;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _lensFormulaDocs = require("@kbn/lens-formula-docs");
var _lodash = require("lodash");
var _math_completion = require("./math_completion");
var _validation = require("../validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/formula/editor/formula_help.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createNewSection(label, description, functionsToDocument, operationDefinitionMap) {
  return {
    label,
    description,
    items: functionsToDocument.sort().map(key => {
      const fnDescription = getFunctionDescriptionAndExamples(key);
      return {
        label: key,
        description: {
          markdownContent: `### ${getFunctionSignatureLabel(key, operationDefinitionMap, false)}
          ${fnDescription !== null && fnDescription !== void 0 ? fnDescription : ''}
        `
        }
      };
    })
  };
}
function getFunctionDescriptionAndExamples(label) {
  var _documentationMap$lab;
  if (_lensFormulaDocs.tinymathFunctions[label]) {
    const [description, examples] = _lensFormulaDocs.tinymathFunctions[label].help.split(`\`\`\``);
    return `${description.replace(/\n/g, '\n\n')}${examples ? `\`\`\`${examples}\`\`\`` : ''}`;
  }
  return (_documentationMap$lab = _lensFormulaDocs.documentationMap[label].documentation) === null || _documentationMap$lab === void 0 ? void 0 : _documentationMap$lab.description;
}
function getDocumentationSections({
  indexPattern,
  operationDefinitionMap
}) {
  const helpGroups = [];
  helpGroups.push({
    label: _i18n.i18n.translate('xpack.lens.formulaDocumentationHeading', {
      defaultMessage: 'How it works'
    }),
    items: []
  });
  helpGroups.push({
    label: _lensFormulaDocs.sections.common.label,
    description: _lensFormulaDocs.sections.common.description,
    items: _lensFormulaDocs.sections.common.items.map(({
      label,
      description
    }) => ({
      label,
      description: {
        markdownContent: description
      }
    }))
  });
  const {
    elasticsearch: esFunctions,
    calculation: calculationFunctions,
    math: mathOperations,
    comparison: comparisonOperations,
    constants: constantsOperations
  } = (0, _lodash.groupBy)((0, _math_completion.getPossibleFunctions)(indexPattern), key => {
    if (key in operationDefinitionMap) {
      var _documentationMap$key;
      return (_documentationMap$key = _lensFormulaDocs.documentationMap[key].documentation) === null || _documentationMap$key === void 0 ? void 0 : _documentationMap$key.section;
    }
    if (key in _lensFormulaDocs.tinymathFunctions) {
      return _lensFormulaDocs.tinymathFunctions[key].section;
    }
  });

  // Es aggs
  helpGroups.push(createNewSection(_lensFormulaDocs.sections.elasticsearch.label, _lensFormulaDocs.sections.elasticsearch.description, esFunctions, operationDefinitionMap));

  // Calculations aggs
  helpGroups.push(createNewSection(_lensFormulaDocs.sections.calculations.label, _lensFormulaDocs.sections.calculations.description, calculationFunctions, operationDefinitionMap));
  helpGroups.push(createNewSection(_lensFormulaDocs.sections.math.label, _lensFormulaDocs.sections.math.description, mathOperations, operationDefinitionMap));
  helpGroups.push(createNewSection(_lensFormulaDocs.sections.comparison.label, _lensFormulaDocs.sections.comparison.description, comparisonOperations, operationDefinitionMap));
  helpGroups.push(createNewSection(_lensFormulaDocs.sections.context.label, _lensFormulaDocs.sections.context.description, constantsOperations, operationDefinitionMap));
  const sections = {
    groups: helpGroups,
    initialSection: /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
      readOnly: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 21
      }
    }, _lensFormulaDocs.sections.howTo)
  };
  return sections;
}
function getFunctionSignatureLabel(name, operationDefinitionMap, getFullSignature = true) {
  if (_lensFormulaDocs.tinymathFunctions[name]) {
    return `${name}(${_lensFormulaDocs.tinymathFunctions[name].positionalArguments.map(({
      name: argName,
      optional,
      type
    }) => `[${argName}]${optional ? '?' : ''}: ${type}`).join(', ')})`;
  }
  if (operationDefinitionMap[name]) {
    var _documentationMap$nam;
    const def = operationDefinitionMap[name];
    const extraArgs = [];
    if (getFullSignature) {
      if (def.filterable) {
        extraArgs.push(_i18n.i18n.translate('xpack.lens.formula.kqlExtraArguments', {
          defaultMessage: '[kql]?: string, [lucene]?: string'
        }));
      }
      if (def.shiftable) {
        extraArgs.push(_i18n.i18n.translate('xpack.lens.formula.shiftExtraArguments', {
          defaultMessage: '[shift]?: string'
        }));
      }
      if (def.canReduceTimeRange) {
        extraArgs.push(_i18n.i18n.translate('xpack.lens.formula.reducedTimeRangeExtraArguments', {
          defaultMessage: '[reducedTimeRange]?: string'
        }));
      }
    }
    const extraComma = extraArgs.length ? ', ' : '';
    return `${name}(${(_documentationMap$nam = _lensFormulaDocs.documentationMap[name].documentation) === null || _documentationMap$nam === void 0 ? void 0 : _documentationMap$nam.signature}${extraComma}${extraArgs.join(', ')})`;
  }
  return '';
}
function getFunctionArgumentsStringified(params) {
  return params.map(({
    name,
    type: argType,
    defaultValue = 5
  }) => `${name}=${argType === 'string' ? `"${defaultValue}"` : defaultValue}`).join(', ');
}

/**
 * Get an array of strings containing all possible information about a specific
 * operation type: examples and infos.
 */
function getHelpTextContent(type, operationDefinitionMap) {
  var _documentationMap$typ, _documentationMap$typ2;
  const definition = operationDefinitionMap[type];
  const description = (_documentationMap$typ = (_documentationMap$typ2 = _lensFormulaDocs.documentationMap[type].documentation) === null || _documentationMap$typ2 === void 0 ? void 0 : _documentationMap$typ2.description) !== null && _documentationMap$typ !== void 0 ? _documentationMap$typ : '';

  // as for the time being just add examples text.
  // Later will enrich with more information taken from the operation definitions.
  const examples = [];
  // If the description already contain examples skip it
  if (!/Example/.test(description)) {
    if (!(0, _validation.hasFunctionFieldArgument)(type)) {
      // ideally this should have the same example automation as the operations below
      examples.push(`${type}()`);
      return {
        description,
        examples
      };
    }
    if (definition.input === 'field') {
      var _definition$operation;
      const mandatoryArgs = ((_definition$operation = definition.operationParams) === null || _definition$operation === void 0 ? void 0 : _definition$operation.filter(({
        required
      }) => required)) || [];
      if (mandatoryArgs.length === 0) {
        examples.push(`${type}(bytes)`);
      }
      if (mandatoryArgs.length) {
        const additionalArgs = getFunctionArgumentsStringified(mandatoryArgs);
        examples.push(`${type}(bytes, ${additionalArgs})`);
      }
      if (definition.operationParams && mandatoryArgs.length !== definition.operationParams.length) {
        const additionalArgs = getFunctionArgumentsStringified(definition.operationParams);
        examples.push(`${type}(bytes, ${additionalArgs})`);
      }
    }
    if (definition.input === 'fullReference') {
      var _definition$operation2;
      const mandatoryArgs = ((_definition$operation2 = definition.operationParams) === null || _definition$operation2 === void 0 ? void 0 : _definition$operation2.filter(({
        required
      }) => required)) || [];
      if (mandatoryArgs.length === 0) {
        examples.push(`${type}(sum(bytes))`);
      }
      if (mandatoryArgs.length) {
        const additionalArgs = getFunctionArgumentsStringified(mandatoryArgs);
        examples.push(`${type}(sum(bytes), ${additionalArgs})`);
      }
      if (definition.operationParams && mandatoryArgs.length !== definition.operationParams.length) {
        const additionalArgs = getFunctionArgumentsStringified(definition.operationParams);
        examples.push(`${type}(sum(bytes), ${additionalArgs})`);
      }
    }
  }
  return {
    description,
    examples
  };
}