"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatColumn = void 0;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatColumn = exports.formatColumn = {
  name: 'lens_format_column',
  type: 'datatable',
  help: '',
  args: {
    format: {
      types: ['string'],
      help: '',
      required: true
    },
    columnId: {
      types: ['string'],
      help: '',
      required: true
    },
    decimals: {
      types: ['number'],
      help: ''
    },
    suffix: {
      types: ['string'],
      help: ''
    },
    parentFormat: {
      types: ['string'],
      help: ''
    },
    compact: {
      types: ['boolean'],
      help: ''
    },
    pattern: {
      types: ['string'],
      help: ''
    },
    fromUnit: {
      types: ['string'],
      help: ''
    },
    toUnit: {
      types: ['string'],
      help: ''
    }
  },
  inputTypes: ['datatable'],
  async fn(...args) {
    /** Build optimization: prevent adding extra code into initial bundle **/
    const {
      formatColumnFn
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../impl/async_fns')));
    return formatColumnFn(...args);
  }
};