"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertDatatableToRawColorMappings = void 0;
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** @deprecated */

/**
 * Old color mapping state meant for type safety during runtime migrations of old configurations
 *
 * @deprecated Use respective vis state (i.e. `DatatableVisualizationState`)
 */

const convertDatatableToRawColorMappings = (state, datasourceStates) => {
  const getColumnMeta = (0, _common.getColumnMetaFn)(datasourceStates);
  const hasDeprecatedColorMappings = state.columns.some(column => {
    return (0, _common.isDeprecatedColorMapping)(column.colorMapping);
  });
  if (!hasDeprecatedColorMappings) return state;
  const convertedColumns = state.columns.map(column => {
    var _column$colorMapping, _column$colorMapping2;
    if ((_column$colorMapping = column.colorMapping) !== null && _column$colorMapping !== void 0 && _column$colorMapping.assignments || (_column$colorMapping2 = column.colorMapping) !== null && _column$colorMapping2 !== void 0 && _column$colorMapping2.specialAssignments) {
      const columnMeta = getColumnMeta === null || getColumnMeta === void 0 ? void 0 : getColumnMeta(state.layerId, column.columnId);
      return {
        ...column,
        colorMapping: (0, _common.convertToRawColorMappings)(column.colorMapping, columnMeta)
      };
    }
    return column;
  });
  return {
    ...state,
    columns: convertedColumns
  };
};
exports.convertDatatableToRawColorMappings = convertDatatableToRawColorMappings;