"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LENS_EMPTY_AS_NULL_DEFAULT_VALUE = void 0;
exports.getLensAPIBucketSharedProps = getLensAPIBucketSharedProps;
exports.getLensAPIMetricSharedProps = getLensAPIMetricSharedProps;
exports.getLensStateBucketSharedProps = getLensStateBucketSharedProps;
exports.getLensStateMetricSharedProps = getLensStateMetricSharedProps;
exports.isAPIColumnOfBucketType = isAPIColumnOfBucketType;
exports.isAPIColumnOfMetricType = isAPIColumnOfMetricType;
exports.isAPIColumnOfReferenceType = isAPIColumnOfReferenceType;
exports.isAPIColumnOfType = isAPIColumnOfType;
exports.isApiColumnOfReferableType = isApiColumnOfReferableType;
exports.isColumnOfReferableType = isColumnOfReferableType;
exports.isLensStateBucketColumnType = isLensStateBucketColumnType;
exports.isLensStateColumnOfType = isLensStateColumnOfType;
var _filter = require("./filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LENS_EMPTY_AS_NULL_DEFAULT_VALUE = exports.LENS_EMPTY_AS_NULL_DEFAULT_VALUE = false;
const LENS_DEFAULT_LABEL = '';
function getLensStateMetricSharedProps(options, dataType = 'number') {
  var _options$label;
  const filter = (0, _filter.fromFilterAPIToLensState)(options.filter);
  return {
    dataType,
    isBucketed: false,
    ...(filter ? {
      filter
    } : {}),
    ...(options.time_scale ? {
      timeScale: options.time_scale
    } : {}),
    ...(options.reduced_time_range ? {
      reducedTimeRange: options.reduced_time_range
    } : {}),
    ...(options.time_shift ? {
      timeShift: options.time_shift
    } : {}),
    label: (_options$label = options.label) !== null && _options$label !== void 0 ? _options$label : LENS_DEFAULT_LABEL,
    // @TODO improve this based on default label logic
    customLabel: options.label != null
  };
}
function getLensAPIMetricSharedProps(options) {
  return {
    ...(options.customLabel ? {
      label: options.label
    } : {}),
    ...(options.timeScale ? {
      time_scale: options.timeScale
    } : {}),
    ...(options.reducedTimeRange ? {
      reduced_time_range: options.reducedTimeRange
    } : {}),
    ...(options.timeShift ? {
      time_shift: options.timeShift
    } : {}),
    ...(options.filter ? {
      filter: (0, _filter.fromFilterLensStateToAPI)(options.filter)
    } : {})
  };
}
function getLensStateBucketSharedProps(options) {
  var _options$field, _options$label2;
  return {
    sourceField: (_options$field = options.field) !== null && _options$field !== void 0 ? _options$field : '',
    label: (_options$label2 = options.label) !== null && _options$label2 !== void 0 ? _options$label2 : LENS_DEFAULT_LABEL,
    customLabel: Boolean(options.label),
    isBucketed: true
  };
}
function getLensAPIBucketSharedProps(options) {
  return {
    field: options.sourceField,
    ...(options.customLabel ? {
      label: options.label
    } : {})
  };
}

/**
 * Type guard to test if a given API column is of the specified operation type
 */

function isAPIColumnOfType(type, column) {
  return column.operation === type;
}
const bucketTypes = ['date_histogram', 'histogram', 'terms', 'range', 'filters'];
const referenceTypes = ['moving_average', 'cumulative_sum', 'differences', 'counter_rate'];
const referrableTypes = ['sum', 'min', 'max', 'average', 'median', 'standard_deviation', 'percentile', 'count', 'unique_count', 'last_value', 'percentile_rank'];
function isAPIColumnOfBucketType(column) {
  return bucketTypes.some(type => isAPIColumnOfType(type, column));
}
function isAPIColumnOfMetricType(column) {
  return !isAPIColumnOfBucketType(column);
}
function isAPIColumnOfReferenceType(column) {
  return referenceTypes.some(type => isAPIColumnOfType(type, column));
}
function isApiColumnOfReferableType(column) {
  return referrableTypes.some(type => isAPIColumnOfType(type, column));
}
function isLensStateColumnOfType(type, column) {
  return column.operationType === type;
}
function isColumnOfReferableType(column) {
  return referrableTypes.some(type => isLensStateColumnOfType(type, column));
}
function isLensStateBucketColumnType(column) {
  return column.isBucketed;
}