"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromRangeOrHistogramLensApiToLensState = fromRangeOrHistogramLensApiToLensState;
exports.fromRangeOrHistogramLensStateToAPI = fromRangeOrHistogramLensStateToAPI;
var _constants = require("../../schema/constants");
var _utils = require("./utils");
var _format = require("./format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fromRangeOrHistogramLensApiToLensState(options) {
  const {
    operation
  } = options;
  if (operation === 'range') {
    var _options$ranges$map;
    return {
      operationType: 'range',
      dataType: 'string',
      ...(0, _utils.getLensStateBucketSharedProps)(options),
      params: {
        type: 'range',
        maxBars: 'auto',
        ranges: (_options$ranges$map = options.ranges.map(({
          gt,
          lte,
          label: rangeLabel
        }) => ({
          from: gt !== null && gt !== void 0 ? gt : null,
          to: lte !== null && lte !== void 0 ? lte : null,
          label: rangeLabel !== null && rangeLabel !== void 0 ? rangeLabel : ''
        }))) !== null && _options$ranges$map !== void 0 ? _options$ranges$map : [{
          from: 0,
          to: _constants.LENS_RANGE_DEFAULT_INTERVAL,
          label: ''
        }],
        format: (0, _format.fromFormatAPIToLensState)(options.format),
        parentFormat: {
          id: 'range',
          params: {
            template: 'arrow_right',
            replaceInfinity: true
          }
        }
      }
    };
  }
  return {
    operationType: 'range',
    dataType: 'number',
    ...(0, _utils.getLensStateBucketSharedProps)(options),
    params: {
      type: 'histogram',
      maxBars: options.granularity,
      ranges: [],
      format: (0, _format.fromFormatAPIToLensState)(options.format),
      includeEmptyRows: options.include_empty_rows
    }
  };
}
function fromRangeOrHistogramLensStateToAPI(column) {
  var _column$params2, _column$params3;
  if (column.params.type === 'range') {
    var _column$params;
    return {
      operation: 'range',
      ...(0, _utils.getLensAPIBucketSharedProps)(column),
      ranges: column.params.ranges.filter(({
        from,
        to
      }) => from != null || to != null).map(({
        from,
        to,
        label
      }) => ({
        ...(from != null ? {
          gt: from
        } : {}),
        ...(to != null ? {
          lte: to
        } : {}),
        ...(label != null ? {
          label
        } : {})
      })),
      ...((_column$params = column.params) !== null && _column$params !== void 0 && _column$params.format ? {
        format: (0, _format.fromFormatLensStateToAPI)(column.params.format)
      } : {})
    };
  }
  return {
    operation: 'histogram',
    include_empty_rows: Boolean(column.params.includeEmptyRows),
    granularity: (_column$params2 = column.params) === null || _column$params2 === void 0 ? void 0 : _column$params2.maxBars,
    ...(0, _utils.getLensAPIBucketSharedProps)(column),
    ...((_column$params3 = column.params) !== null && _column$params3 !== void 0 && _column$params3.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(column.params.format)
    } : {})
  };
}