"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromPercentileLensStateToAPI = exports.fromPercentileAPItoLensState = void 0;
var _format = require("./format");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromPercentileAPItoLensState = options => {
  const {
    field,
    format,
    percentile
  } = options;
  return {
    operationType: 'percentile',
    sourceField: field,
    ...(0, _utils.getLensStateMetricSharedProps)(options),
    params: {
      ...(format ? {
        format: (0, _format.fromFormatAPIToLensState)(format)
      } : {}),
      percentile
    }
  };
};
exports.fromPercentileAPItoLensState = fromPercentileAPItoLensState;
const fromPercentileLensStateToAPI = options => {
  var _options$params;
  return {
    operation: options.operationType,
    field: options.sourceField,
    percentile: options.params.percentile,
    ...(0, _utils.getLensAPIMetricSharedProps)(options),
    ...((_options$params = options.params) !== null && _options$params !== void 0 && _options$params.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(options.params.format)
    } : {})
  };
};
exports.fromPercentileLensStateToAPI = fromPercentileLensStateToAPI;