"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertLegendToAPIFormat = convertLegendToAPIFormat;
exports.convertLegendToStateFormat = convertLegendToStateFormat;
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const StatsAPIToOldState = {
  avg: 'average',
  last_value: 'lastValue',
  first_value: 'firstValue',
  last_non_null_value: 'lastNonNullValue',
  first_non_null_value: 'firstNonNullValue',
  current_and_last_value: 'currentAndLastValue',
  difference_percentage: 'differencePercent',
  standard_deviation: 'stdDeviation',
  distinct_count: 'distinctCount'
};
function isAPIMappedStatistic(stat) {
  return stat in StatsAPIToOldState;
}
function mapStatToCamelCase(stat) {
  if (isAPIMappedStatistic(stat)) {
    return StatsAPIToOldState[stat];
  }
  return stat;
}
const StatsStateToAPI = {
  average: 'avg',
  lastValue: 'last_value',
  firstValue: 'first_value',
  lastNonNullValue: 'last_non_null_value',
  firstNonNullValue: 'first_non_null_value',
  currentAndLastValue: 'current_and_last_value',
  differencePercent: 'difference_percentage',
  stdDeviation: 'standard_deviation',
  distinctCount: 'distinct_count'
};
function isStateMappedStatistic(stat) {
  return stat in StatsStateToAPI;
}
function mapStatToSnakeCase(stat) {
  if (isStateMappedStatistic(stat)) {
    return StatsStateToAPI[stat];
  }
  return stat;
}
const DEFAULT_LEGEND_POSITON = 'right';
function extractAlignment(legend) {
  if (legend !== null && legend !== void 0 && legend.inside) {
    var _legend$alignment$spl, _legend$alignment;
    const [verticalAlignment, horizontalAlignment] = (_legend$alignment$spl = (_legend$alignment = legend.alignment) === null || _legend$alignment === void 0 ? void 0 : _legend$alignment.split('_')) !== null && _legend$alignment$spl !== void 0 ? _legend$alignment$spl : ['top', 'right'];
    return {
      verticalAlignment,
      horizontalAlignment
    };
  }
  return {};
}
function getLegendSize(size) {
  switch (size) {
    case 'small':
      return _chartExpressionsCommon.LegendSize.SMALL;
    case 'medium':
      return _chartExpressionsCommon.LegendSize.MEDIUM;
    case 'large':
      return _chartExpressionsCommon.LegendSize.LARGE;
    case 'xlarge':
      return _chartExpressionsCommon.LegendSize.EXTRA_LARGE;
    default:
      return _chartExpressionsCommon.LegendSize.AUTO;
  }
}
function convertLegendToStateFormat(legend) {
  var _legend$statistics, _legend$statistics2, _legend$position;
  const newStateLegend = {
    isVisible: Boolean(legend === null || legend === void 0 ? void 0 : legend.visible),
    shouldTruncate: Boolean(legend === null || legend === void 0 ? void 0 : legend.truncate_after_lines),
    // 0 will be interpreted as false
    ...(legend !== null && legend !== void 0 && legend.truncate_after_lines ? {
      maxLines: legend === null || legend === void 0 ? void 0 : legend.truncate_after_lines
    } : {}),
    ...(legend !== null && legend !== void 0 && legend.statistics ? {
      legendStats: ((_legend$statistics = legend === null || legend === void 0 ? void 0 : legend.statistics) !== null && _legend$statistics !== void 0 ? _legend$statistics : []).map(mapStatToCamelCase)
    } : {}),
    ...(legend !== null && legend !== void 0 && legend.statistics ? {
      layout: legend !== null && legend !== void 0 && (_legend$statistics2 = legend.statistics) !== null && _legend$statistics2 !== void 0 && _legend$statistics2.length ? _chartExpressionsCommon.LegendLayout.Table : _chartExpressionsCommon.LegendLayout.List
    } : {}),
    ...extractAlignment(legend),
    ...(legend !== null && legend !== void 0 && legend.inside ? {
      position: DEFAULT_LEGEND_POSITON,
      ...(legend !== null && legend !== void 0 && legend.columns ? {
        floatingColumns: legend === null || legend === void 0 ? void 0 : legend.columns
      } : {})
    } : {
      position: (_legend$position = legend === null || legend === void 0 ? void 0 : legend.position) !== null && _legend$position !== void 0 ? _legend$position : DEFAULT_LEGEND_POSITON,
      legendSize: legend !== null && legend !== void 0 && legend.size ? getLegendSize(legend.size) : _chartExpressionsCommon.LegendSize.AUTO
    })
  };
  return {
    legend: newStateLegend
  };
}
function getLegendSizeAPI(size) {
  switch (size) {
    case _chartExpressionsCommon.LegendSize.SMALL:
      return {
        size: 'small'
      };
    case _chartExpressionsCommon.LegendSize.MEDIUM:
      return {
        size: 'medium'
      };
    case _chartExpressionsCommon.LegendSize.LARGE:
      return {
        size: 'large'
      };
    case _chartExpressionsCommon.LegendSize.EXTRA_LARGE:
      return {
        size: 'xlarge'
      };
    default:
      return {};
  }
}

// @TODO improve this check
function isLegendInside(legend) {
  return legend.legendSize == null && (legend.floatingColumns != null || legend.verticalAlignment != null || legend.horizontalAlignment != null);
}
function getLegendAlignment(legend) {
  var _legend$verticalAlign, _legend$horizontalAli;
  if (!legend.verticalAlignment && !legend.horizontalAlignment) {
    return {};
  }
  return {
    alignment: `${(_legend$verticalAlign = legend.verticalAlignment) !== null && _legend$verticalAlign !== void 0 ? _legend$verticalAlign : 'top'}_${(_legend$horizontalAli = legend.horizontalAlignment) !== null && _legend$horizontalAli !== void 0 ? _legend$horizontalAli : 'right'}`
  };
}
function getLegendLayout(legend) {
  if (isLegendInside(legend)) {
    return {
      inside: true,
      ...(legend.floatingColumns ? {
        columns: legend.floatingColumns
      } : {}),
      ...getLegendAlignment(legend)
    };
  }
  return {
    inside: false,
    ...getLegendSizeAPI(legend.legendSize),
    ...(legend.position ? {
      position: legend.position
    } : {})
  };
}
function convertLegendToAPIFormat(legend) {
  var _legend$legendStats;
  const legendOptions = {
    visible: legend.isVisible,
    ...((legend === null || legend === void 0 ? void 0 : legend.maxLines) == null ? {} : {
      truncate_after_lines: legend.maxLines
    }),
    ...(legend !== null && legend !== void 0 && (_legend$legendStats = legend.legendStats) !== null && _legend$legendStats !== void 0 && _legend$legendStats.length ? {
      statistics: legend.legendStats.map(mapStatToSnakeCase)
    } : {}),
    ...getLegendLayout(legend)
  };
  return {
    legend: legendOptions
  };
}