"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromAPItoLensState = fromAPItoLensState;
exports.fromLensStateToAPI = fromLensStateToAPI;
var _types = require("../../types");
var _utils = require("../utils");
var _esql_column = require("../columns/esql_column");
var _metric = require("../columns/metric");
var _buckets = require("../columns/buckets");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'region_map_accessor';
function getAccessorName(type) {
  return `${ACCESSOR}_${type}`;
}
function buildVisualizationState(config) {
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    valueAccessor: getAccessorName('metric'),
    regionAccessor: getAccessorName('region'),
    ...(layer.region.ems ? {
      emsLayerId: layer.region.ems.boundaries,
      emsField: layer.region.ems.join
    } : {})
  };
}
function getRegionMapDataset(layer, adHocDataViews, references, adhocReferences = [], layerId) {
  const dataset = (0, _utils.buildDatasetState)(layer, layerId, adHocDataViews, references, adhocReferences);
  if (!dataset || dataset.type == null) {
    throw new Error('Unsupported dataset type');
  }
  return dataset;
}
function getRegionMapMetric(layer, visualization) {
  if (visualization.valueAccessor == null) {
    throw new Error('Metric accessor is missing in the visualization state');
  }
  return (0, _utils.isTextBasedLayer)(layer) ? (0, _esql_column.getValueApiColumn)(visualization.valueAccessor, layer) : (0, _utils.operationFromColumn)(visualization.valueAccessor, layer);
}
function getRegionMapRegion(layer, visualization) {
  if (visualization.regionAccessor == null) {
    throw new Error('Region accessor is missing in the visualization state');
  }
  return {
    ...((0, _utils.isTextBasedLayer)(layer) ? (0, _esql_column.getValueApiColumn)(visualization.regionAccessor, layer) : (0, _utils.operationFromColumn)(visualization.regionAccessor, layer)),
    ...(visualization.emsLayerId && visualization.emsField ? {
      ems: {
        boundaries: visualization.emsLayerId,
        join: visualization.emsField
      }
    } : {})
  };
}
function reverseBuildVisualizationState(visualization, layer, layerId, adHocDataViews, references, adhocReferences) {
  const dataset = getRegionMapDataset(layer, adHocDataViews, references, adhocReferences, layerId);
  const metric = getRegionMapMetric(layer, visualization);
  const region = getRegionMapRegion(layer, visualization);
  return {
    type: 'region_map',
    dataset,
    ...(0, _utils.generateApiLayer)(layer),
    metric,
    region
  };
}
function buildFormBasedLayer(layer) {
  const columns = (0, _metric.fromMetricAPItoLensState)(layer.metric);
  const layers = (0, _utils.generateLayer)(_types.DEFAULT_LAYER_ID, layer);
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  (0, _utils.addLayerColumn)(defaultLayer, getAccessorName('metric'), columns);
  const breakdownColumn = (0, _buckets.fromBucketLensApiToLensState)(layer.region, columns.map(col => ({
    column: col,
    id: getAccessorName('metric')
  })));
  (0, _utils.addLayerColumn)(defaultLayer, getAccessorName('region'), breakdownColumn, true);
  return layers;
}
function getValueColumns(layer) {
  return [(0, _esql_column.getValueColumn)(getAccessorName('metric'), layer.metric.column, 'number'), (0, _esql_column.getValueColumn)(getAccessorName('region'), layer.region.column)];
}
function fromAPItoLensState(config) {
  var _regularDataViews$;
  const _buildDataLayer = (cfg, i) => buildFormBasedLayer(cfg);
  const {
    layers,
    usedDataviews
  } = (0, _utils.buildDatasourceStates)(config, _buildDataLayer, getValueColumns);
  const visualization = buildVisualizationState(config);
  const {
    adHocDataViews,
    internalReferences
  } = (0, _utils.getAdhocDataviews)(usedDataviews);
  const regularDataViews = Object.values(usedDataviews).filter(v => v.type === 'dataView');
  const references = regularDataViews.length ? (0, _utils.buildReferences)({
    [_types.DEFAULT_LAYER_ID]: (_regularDataViews$ = regularDataViews[0]) === null || _regularDataViews$ === void 0 ? void 0 : _regularDataViews$.id
  }) : [];
  return {
    visualizationType: 'lnsChoropleth',
    ...(0, _utils2.getSharedChartAPIToLensState)(config),
    references,
    state: {
      datasourceStates: layers,
      internalReferences,
      visualization,
      adHocDataViews: config.dataset.type === 'index' ? adHocDataViews : {}
    }
  };
}
function fromLensStateToAPI(config) {
  var _config$state$adHocDa;
  const {
    state
  } = config;
  const visualization = state.visualization;
  const layers = (0, _utils2.getDatasourceLayers)(state);
  const [layerId, layer] = (0, _utils2.getLensStateLayer)(layers, visualization.layerId);
  const visualizationState = {
    ...(0, _utils2.getSharedChartLensStateToAPI)(config),
    ...reverseBuildVisualizationState(visualization, layer, layerId !== null && layerId !== void 0 ? layerId : _types.DEFAULT_LAYER_ID, (_config$state$adHocDa = config.state.adHocDataViews) !== null && _config$state$adHocDa !== void 0 ? _config$state$adHocDa : {}, config.references, config.state.internalReferences)
  };
  return visualizationState;
}