"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromLensStateToAPI = fromLensStateToAPI;
var _lensCommon = require("@kbn/lens-common");
var _utils = require("../utils");
var _coloring = require("../../coloring");
var _types = require("../../../types");
var _utils2 = require("../../utils");
var _esql_column = require("../../columns/esql_column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getLegendProps(legend) {
  return {
    visible: legend.isVisible,
    position: legend.position,
    ...(0, _utils.stripUndefined)({
      truncate_after_lines: legend.maxLines,
      size: legend.legendSize
    })
  };
}
function getOrientationFromRotation(rotation) {
  return rotation === -45 ? 'angled' : rotation === -90 ? 'vertical' : 'horizontal';
}
function getGridConfigProps(gridConfig) {
  return {
    x: {
      labels: {
        visible: gridConfig.isXAxisLabelVisible,
        ...(gridConfig.xAxisLabelRotation !== undefined && {
          orientation: getOrientationFromRotation(gridConfig.xAxisLabelRotation)
        })
      },
      title: {
        value: gridConfig.xTitle,
        visible: gridConfig.isXAxisTitleVisible
      }
    },
    y: {
      labels: {
        visible: gridConfig.isYAxisLabelVisible
      },
      title: {
        value: gridConfig.yTitle,
        visible: gridConfig.isYAxisTitleVisible
      }
    }
  };
}
function reverseBuildVisualizationState(visualization, layer, layerId, adHocDataViews, references, adhocReferences) {
  const valueAccessor = visualization.valueAccessor;
  if (valueAccessor == null) {
    throw new Error('Value accessor is missing in the visualization state');
  }
  const sharedProps = {
    ...(0, _utils2.generateApiLayer)(layer),
    type: _lensCommon.HEATMAP_NAME,
    legend: getLegendProps(visualization.legend),
    axes: getGridConfigProps(visualization.gridConfig),
    cells: {
      labels: {
        visible: visualization.gridConfig.isCellLabelVisible
      }
    }
  };
  const paletteProps = {
    ...(visualization.palette && {
      color: (0, _coloring.fromColorByValueLensStateToAPI)(visualization.palette)
    })
  };
  if ((0, _utils2.isTextBasedLayer)(layer)) {
    if (!visualization.xAccessor) {
      throw new Error('xAccessor is missing in the visualization state');
    }
    const dataset = (0, _utils2.buildDatasetStateESQL)(layer);
    return {
      ...sharedProps,
      dataset,
      metric: {
        ...(0, _esql_column.getValueApiColumn)(valueAccessor, layer),
        ...paletteProps
      },
      xAxis: (0, _esql_column.getValueApiColumn)(visualization.xAccessor, layer),
      ...(visualization.yAccessor && {
        yAxis: (0, _esql_column.getValueApiColumn)(visualization.yAccessor, layer)
      })
    };
  }
  const dataset = (0, _utils2.buildDatasetStateNoESQL)(layer, layerId, adHocDataViews, references, adhocReferences);
  return {
    ...sharedProps,
    dataset,
    metric: {
      ...(0, _utils2.operationFromColumn)(valueAccessor, layer),
      ...paletteProps
    },
    xAxis: (0, _utils2.operationFromColumn)(visualization.xAccessor, layer),
    yAxis: visualization.yAccessor && (0, _utils2.operationFromColumn)(visualization.yAccessor, layer)
  };
}
function fromLensStateToAPI(config) {
  var _config$state$adHocDa;
  const {
    state
  } = config;
  const visualization = state.visualization;
  const layers = (0, _utils.getDatasourceLayers)(state);

  // Layers can be in any order, so make sure to get the main one
  const [layerId, layer] = Object.entries(layers).find(([, l]) => !('linkToLayers' in l) || l.linkToLayers == null);
  return {
    ...(0, _utils.getSharedChartLensStateToAPI)(config),
    ...reverseBuildVisualizationState(visualization, layer, layerId !== null && layerId !== void 0 ? layerId : _types.DEFAULT_LAYER_ID, (_config$state$adHocDa = config.state.adHocDataViews) !== null && _config$state$adHocDa !== void 0 ? _config$state$adHocDa : {}, config.references, config.state.internalReferences)
  };
}