"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromAPItoLensState = fromAPItoLensState;
var _lensCommon = require("@kbn/lens-common");
var _utils = require("../utils");
var _coloring = require("../../coloring");
var _types = require("../../../types");
var _utils2 = require("../../utils");
var _metric = require("../../columns/metric");
var _buckets = require("../../columns/buckets");
var _esql_column = require("../../columns/esql_column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'heatmap_value_accessor';
function getAccessorName(type) {
  return `${ACCESSOR}_${type}`;
}
function getRotationFromOrientation(orientation) {
  if (!orientation) return;
  return orientation === 'angled' ? -45 : orientation === 'vertical' ? -90 : 0;
}
function buildVisualizationState(config) {
  var _layer$axes, _layer$axes$x, _layer$axes$x$labels, _layer$cells$labels$v, _layer$cells, _layer$cells$labels, _layer$axes$x$labels$, _layer$axes2, _layer$axes2$x, _layer$axes2$x$labels, _layer$axes$x$title$v, _layer$axes3, _layer$axes3$x, _layer$axes3$x$title, _layer$axes$y$labels$, _layer$axes4, _layer$axes4$y, _layer$axes4$y$labels, _layer$axes$y$title$v, _layer$axes5, _layer$axes5$y, _layer$axes5$y$title, _layer$axes6, _layer$axes6$x, _layer$axes6$x$title, _layer$axes7, _layer$axes7$y, _layer$axes7$y$title, _layer$legend$visible, _layer$legend, _layer$legend$positio, _layer$legend2, _layer$legend3, _layer$legend4;
  const layer = config;
  const valueAccessor = getAccessorName('value');
  const basePalette = layer.metric.color && (0, _coloring.fromColorByValueAPIToLensState)(layer.metric.color);
  const xAxisLabelRotation = getRotationFromOrientation((_layer$axes = layer.axes) === null || _layer$axes === void 0 ? void 0 : (_layer$axes$x = _layer$axes.x) === null || _layer$axes$x === void 0 ? void 0 : (_layer$axes$x$labels = _layer$axes$x.labels) === null || _layer$axes$x$labels === void 0 ? void 0 : _layer$axes$x$labels.orientation);
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    layerType: 'data',
    shape: 'heatmap',
    valueAccessor,
    xAccessor: getAccessorName('x'),
    ...(layer.yAxis ? {
      yAccessor: getAccessorName('y')
    } : {}),
    gridConfig: {
      type: _lensCommon.HEATMAP_GRID_NAME,
      isCellLabelVisible: (_layer$cells$labels$v = (_layer$cells = layer.cells) === null || _layer$cells === void 0 ? void 0 : (_layer$cells$labels = _layer$cells.labels) === null || _layer$cells$labels === void 0 ? void 0 : _layer$cells$labels.visible) !== null && _layer$cells$labels$v !== void 0 ? _layer$cells$labels$v : false,
      isXAxisLabelVisible: (_layer$axes$x$labels$ = (_layer$axes2 = layer.axes) === null || _layer$axes2 === void 0 ? void 0 : (_layer$axes2$x = _layer$axes2.x) === null || _layer$axes2$x === void 0 ? void 0 : (_layer$axes2$x$labels = _layer$axes2$x.labels) === null || _layer$axes2$x$labels === void 0 ? void 0 : _layer$axes2$x$labels.visible) !== null && _layer$axes$x$labels$ !== void 0 ? _layer$axes$x$labels$ : true,
      isXAxisTitleVisible: (_layer$axes$x$title$v = (_layer$axes3 = layer.axes) === null || _layer$axes3 === void 0 ? void 0 : (_layer$axes3$x = _layer$axes3.x) === null || _layer$axes3$x === void 0 ? void 0 : (_layer$axes3$x$title = _layer$axes3$x.title) === null || _layer$axes3$x$title === void 0 ? void 0 : _layer$axes3$x$title.visible) !== null && _layer$axes$x$title$v !== void 0 ? _layer$axes$x$title$v : false,
      isYAxisLabelVisible: (_layer$axes$y$labels$ = (_layer$axes4 = layer.axes) === null || _layer$axes4 === void 0 ? void 0 : (_layer$axes4$y = _layer$axes4.y) === null || _layer$axes4$y === void 0 ? void 0 : (_layer$axes4$y$labels = _layer$axes4$y.labels) === null || _layer$axes4$y$labels === void 0 ? void 0 : _layer$axes4$y$labels.visible) !== null && _layer$axes$y$labels$ !== void 0 ? _layer$axes$y$labels$ : true,
      isYAxisTitleVisible: (_layer$axes$y$title$v = (_layer$axes5 = layer.axes) === null || _layer$axes5 === void 0 ? void 0 : (_layer$axes5$y = _layer$axes5.y) === null || _layer$axes5$y === void 0 ? void 0 : (_layer$axes5$y$title = _layer$axes5$y.title) === null || _layer$axes5$y$title === void 0 ? void 0 : _layer$axes5$y$title.visible) !== null && _layer$axes$y$title$v !== void 0 ? _layer$axes$y$title$v : false,
      ...(0, _utils.stripUndefined)({
        xTitle: (_layer$axes6 = layer.axes) === null || _layer$axes6 === void 0 ? void 0 : (_layer$axes6$x = _layer$axes6.x) === null || _layer$axes6$x === void 0 ? void 0 : (_layer$axes6$x$title = _layer$axes6$x.title) === null || _layer$axes6$x$title === void 0 ? void 0 : _layer$axes6$x$title.value,
        yTitle: (_layer$axes7 = layer.axes) === null || _layer$axes7 === void 0 ? void 0 : (_layer$axes7$y = _layer$axes7.y) === null || _layer$axes7$y === void 0 ? void 0 : (_layer$axes7$y$title = _layer$axes7$y.title) === null || _layer$axes7$y$title === void 0 ? void 0 : _layer$axes7$y$title.value,
        xAxisLabelRotation
      })
    },
    legend: {
      isVisible: (_layer$legend$visible = (_layer$legend = layer.legend) === null || _layer$legend === void 0 ? void 0 : _layer$legend.visible) !== null && _layer$legend$visible !== void 0 ? _layer$legend$visible : true,
      position: (_layer$legend$positio = (_layer$legend2 = layer.legend) === null || _layer$legend2 === void 0 ? void 0 : _layer$legend2.position) !== null && _layer$legend$positio !== void 0 ? _layer$legend$positio : 'right',
      type: 'heatmap_legend',
      ...(0, _utils.stripUndefined)({
        maxLines: (_layer$legend3 = layer.legend) === null || _layer$legend3 === void 0 ? void 0 : _layer$legend3.truncate_after_lines,
        legendSize: (_layer$legend4 = layer.legend) === null || _layer$legend4 === void 0 ? void 0 : _layer$legend4.size
      })
    },
    ...(basePalette && {
      palette: {
        ...basePalette,
        accessor: valueAccessor
      }
    })
  };
}
function buildFormBasedLayer(layer) {
  const metricColumns = (0, _metric.fromMetricAPItoLensState)(layer.metric);
  const layers = (0, _utils2.generateLayer)(_types.DEFAULT_LAYER_ID, layer);
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  (0, _utils2.addLayerColumn)(defaultLayer, getAccessorName('value'), metricColumns);
  if (layer.xAxis) {
    const columnName = getAccessorName('x');
    const xAxisColumn = (0, _buckets.fromBucketLensApiToLensState)(layer.xAxis, metricColumns.map(col => ({
      column: col,
      id: getAccessorName('value')
    })));
    (0, _utils2.addLayerColumn)(defaultLayer, columnName, xAxisColumn, true);
  }
  if (layer.yAxis) {
    const columnName = getAccessorName('y');
    const yAxisColumn = (0, _buckets.fromBucketLensApiToLensState)(layer.yAxis, metricColumns.map(col => ({
      column: col,
      id: getAccessorName('value')
    })));
    (0, _utils2.addLayerColumn)(defaultLayer, columnName, yAxisColumn, true);
  }
  return layers;
}
function getValueColumns(layer) {
  return [(0, _esql_column.getValueColumn)(getAccessorName('value'), layer.metric.column, 'number'), ...(layer.xAxis ? [(0, _esql_column.getValueColumn)(getAccessorName('x'), layer.xAxis.column)] : []), ...(layer.yAxis ? [(0, _esql_column.getValueColumn)(getAccessorName('y'), layer.yAxis.column)] : [])];
}
function fromAPItoLensState(config) {
  var _regularDataViews$;
  const _buildDataLayer = (cfg, i) => buildFormBasedLayer(cfg);
  const {
    layers,
    usedDataviews
  } = (0, _utils2.buildDatasourceStates)(config, _buildDataLayer, getValueColumns);
  const visualization = buildVisualizationState(config);
  const {
    adHocDataViews,
    internalReferences
  } = (0, _utils2.getAdhocDataviews)(usedDataviews);
  const regularDataViews = Object.values(usedDataviews).filter(v => v.type === 'dataView');
  const references = regularDataViews.length ? (0, _utils2.buildReferences)({
    [_types.DEFAULT_LAYER_ID]: (_regularDataViews$ = regularDataViews[0]) === null || _regularDataViews$ === void 0 ? void 0 : _regularDataViews$.id
  }) : [];
  return {
    visualizationType: _lensCommon.LENS_HEATMAP_ID,
    ...(0, _utils.getSharedChartAPIToLensState)(config),
    references,
    state: {
      datasourceStates: layers,
      internalReferences,
      visualization,
      adHocDataViews: config.dataset.type === 'index' ? adHocDataViews : {}
    }
  };
}