"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unifiedSearchFilterSchema = exports.filterWithLabelSchema = exports.filterSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const filterSchema = exports.filterSchema = _configSchema.schema.object({
  language: _configSchema.schema.oneOf([_configSchema.schema.literal('kuery'), _configSchema.schema.literal('lucene')], {
    defaultValue: 'kuery'
  }),
  /**
   * Filter query
   */
  query: _configSchema.schema.string({
    meta: {
      description: 'Filter query'
    }
  })
});
const filterWithLabelSchema = exports.filterWithLabelSchema = _configSchema.schema.object({
  /**
   * Filter query
   */
  filter: filterSchema,
  /**
   * Label for the filter
   */
  label: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Label for the filter'
    }
  }))
});
const FilterQueryType = _configSchema.schema.object({
  match_phrase: _configSchema.schema.maybe(_configSchema.schema.any({})),
  prefix: _configSchema.schema.maybe(_configSchema.schema.any({})),
  exists: _configSchema.schema.maybe(_configSchema.schema.any({})),
  match: _configSchema.schema.maybe(_configSchema.schema.any({})),
  wildcard: _configSchema.schema.maybe(_configSchema.schema.any({})),
  bool: _configSchema.schema.maybe(_configSchema.schema.any({})),
  range: _configSchema.schema.maybe(_configSchema.schema.any({}))
});

/**
 * Unified search filter schema that can accept either a full filter object or a simple query string.
 */
const unifiedSearchFilterSchema = exports.unifiedSearchFilterSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  query: _configSchema.schema.oneOf([_configSchema.schema.string(), FilterQueryType]),
  meta: _configSchema.schema.maybe(_configSchema.schema.object({})),
  language: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('kuery'), _configSchema.schema.literal('lucene')]))
}), FilterQueryType.extends({
  meta: _configSchema.schema.maybe(_configSchema.schema.object({})),
  language: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('kuery'), _configSchema.schema.literal('lucene')]))
})]);