"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.regionMapStateSchemaNoESQL = exports.regionMapStateSchemaESQL = exports.regionMapStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _metric_ops = require("../metric_ops");
var _dataset = require("../dataset");
var _shared = require("../shared");
var _shared2 = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const regionMapStateRegionOptionsSchema = _configSchema.schema.object({
  ems: _configSchema.schema.maybe(_configSchema.schema.object({
    boundaries: _configSchema.schema.string({
      meta: {
        description: 'EMS boundaries'
      }
    }),
    join: _configSchema.schema.string({
      meta: {
        description: 'EMS join field'
      }
    })
  }))
});
const regionMapStateSchemaNoESQL = exports.regionMapStateSchemaNoESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('region_map'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.dslOnlyPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetSchema,
  /**
   * Metric configuration
   */
  metric: _metric_ops.fieldMetricOrFormulaOperationDefinitionSchema,
  /**
   * Configure how to break down to regions
   */
  region: (0, _shared2.mergeAllBucketsWithChartDimensionSchema)(regionMapStateRegionOptionsSchema)
});
const regionMapStateSchemaESQL = exports.regionMapStateSchemaESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('region_map'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetEsqlTableSchema,
  /**
   * Metric configuration
   */
  metric: _configSchema.schema.allOf([_configSchema.schema.object(_metric_ops.genericOperationOptionsSchema), _metric_ops.esqlColumnSchema]),
  /**
   * Configure how to break down to regions
   */
  region: _configSchema.schema.allOf([regionMapStateRegionOptionsSchema, _metric_ops.esqlColumnSchema])
});
const regionMapStateSchema = exports.regionMapStateSchema = _configSchema.schema.oneOf([regionMapStateSchemaNoESQL, regionMapStateSchemaESQL]);