"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pieStateSchemaNoESQL = exports.pieStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _metric_ops = require("../metric_ops");
var _color = require("../color");
var _dataset = require("../dataset");
var _shared = require("../shared");
var _shared2 = require("./shared");
var _partition_shared = require("./partition_shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Shared visualization options for pie/donut charts including legend, value display, and label positioning
 */
const pieStateSharedSchema = {
  legend: _configSchema.schema.maybe(_configSchema.schema.object({
    nested: _partition_shared.legendNestedSchema,
    truncate_after_lines: _partition_shared.legendTruncateAfterLinesSchema,
    visible: _partition_shared.legendVisibleSchema,
    size: _partition_shared.legendSizeSchema
  }, {
    meta: {
      description: 'Legend configuration for pie/donut chart'
    }
  })),
  value_display: _partition_shared.valueDisplaySchema,
  label_position: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('hidden'), _configSchema.schema.literal('inside'), _configSchema.schema.literal('outside')], {
    meta: {
      description: 'Position of slice labels: hidden, inside, or outside'
    }
  })),
  donut_hole: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('none'), _configSchema.schema.literal('small'), _configSchema.schema.literal('medium'), _configSchema.schema.literal('large')], {
    meta: {
      description: 'Donut hole size: none (pie), small, medium, or large'
    }
  }))
};

/**
 * Color configuration for primary metric in pie/donut chart
 */
const partitionStatePrimaryMetricOptionsSchema = _configSchema.schema.object({
  color: _configSchema.schema.maybe(_color.staticColorSchema)
}, {
  meta: {
    description: 'Primary metric visual options including static color'
  }
});

/**
 * Breakdown configuration including color mapping and collapse behavior
 */
const partitionStateBreakdownByOptionsSchema = _configSchema.schema.object({
  color: _configSchema.schema.maybe(_configSchema.schema.oneOf([_color.colorByValueSchema, _color.colorMappingSchema], {
    meta: {
      description: 'Color configuration: by value (palette-based) or mapping (custom rules)'
    }
  })),
  collapse_by: _configSchema.schema.maybe(_shared.collapseBySchema)
}, {
  meta: {
    description: 'Breakdown dimension options with color and collapse configuration'
  }
});

/**
 * Pie/donut chart type
 */
const pieTypeSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('pie'), _configSchema.schema.literal('donut')], {
  meta: {
    description: 'Chart type: pie or donut'
  }
});
function validateGroupings(obj) {
  var _obj$group_by$filter$2, _obj$group_by2;
  if (obj.metrics.length > 1) {
    var _obj$group_by$filter$, _obj$group_by;
    if (((_obj$group_by$filter$ = (_obj$group_by = obj.group_by) === null || _obj$group_by === void 0 ? void 0 : _obj$group_by.filter(def => def.collapse_by == null).length) !== null && _obj$group_by$filter$ !== void 0 ? _obj$group_by$filter$ : 0) > 2) {
      return 'When using multiple metrics, the number of group by dimensions must not exceed 2 (collapsed dimensions do not count).';
    }
  }
  if (((_obj$group_by$filter$2 = (_obj$group_by2 = obj.group_by) === null || _obj$group_by2 === void 0 ? void 0 : _obj$group_by2.filter(def => def.collapse_by == null).length) !== null && _obj$group_by$filter$2 !== void 0 ? _obj$group_by$filter$2 : 0) > 3) {
    return 'The number of non-collapsed group by dimensions must not exceed 3.';
  }
}

/**
 * Pie/donut chart configuration for standard (non-ES|QL) queries
 */
const pieStateSchemaNoESQL = exports.pieStateSchemaNoESQL = _configSchema.schema.object({
  type: pieTypeSchema,
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetSchema,
  ...pieStateSharedSchema,
  metrics: _configSchema.schema.arrayOf((0, _shared2.mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps)(partitionStatePrimaryMetricOptionsSchema), {
    minSize: 1,
    meta: {
      description: 'Array of metric configurations (minimum 1)'
    }
  }),
  group_by: _configSchema.schema.maybe(_configSchema.schema.arrayOf((0, _shared2.mergeAllBucketsWithChartDimensionSchema)(partitionStateBreakdownByOptionsSchema), {
    minSize: 1,
    meta: {
      description: 'Array of breakdown dimensions (minimum 1, maximum 3)'
    }
  }))
}, {
  meta: {
    description: 'Pie/donut chart configuration for standard queries'
  },
  validate: validateGroupings
});

/**
 * Pie/donut chart configuration for ES|QL queries
 */
const pieStateSchemaESQL = _configSchema.schema.object({
  type: pieTypeSchema,
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetEsqlTableSchema,
  ...pieStateSharedSchema,
  metrics: _configSchema.schema.arrayOf(_configSchema.schema.allOf([_configSchema.schema.object(_metric_ops.genericOperationOptionsSchema), partitionStatePrimaryMetricOptionsSchema, _metric_ops.esqlColumnSchema], {
    meta: {
      description: 'ES|QL column reference for primary metric'
    }
  }), {
    minSize: 1,
    meta: {
      description: 'Array of metric configurations (minimum 1)'
    }
  }),
  group_by: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.allOf([partitionStateBreakdownByOptionsSchema, _metric_ops.esqlColumnSchema], {
    meta: {
      description: 'ES|QL column reference for breakdown dimension'
    }
  }), {
    minSize: 1,
    meta: {
      description: 'Array of breakdown dimensions (minimum 1, maximum 3)'
    }
  }))
}, {
  meta: {
    description: 'Pie/donut chart configuration for ES|QL queries'
  },
  validate: validateGroupings
});

/**
 * Complete pie/donut chart configuration supporting both standard and ES|QL queries
 */
const pieStateSchema = exports.pieStateSchema = _configSchema.schema.oneOf([pieStateSchemaNoESQL, pieStateSchemaESQL], {
  meta: {
    description: 'Pie/donut chart state: standard query or ES|QL query'
  }
});