"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.heatmapStateSchemaNoESQL = exports.heatmapStateSchemaESQL = exports.heatmapStateSchema = void 0;
var _lodash = require("lodash");
var _configSchema = require("@kbn/config-schema");
var _dataset = require("../dataset");
var _color = require("../color");
var _metric_ops = require("../metric_ops");
var _shared = require("../shared");
var _shared2 = require("./shared");
var _alignments = require("../alignments");
var _enums = require("../enums");
var _bucket_ops = require("../bucket_ops");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const legendSchemaProps = {
  truncate_after_lines: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'Number of lines before truncating legend text'
    }
  })),
  visible: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Whether to show the legend'
    }
  })),
  size: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('auto'), _configSchema.schema.literal('small'), _configSchema.schema.literal('medium'), _configSchema.schema.literal('large'), _configSchema.schema.literal('xlarge')], {
    defaultValue: 'auto',
    meta: {
      description: 'Size of the legend'
    }
  })),
  position: _configSchema.schema.maybe((0, _alignments.positionSchema)({
    meta: {
      description: 'Legend position'
    }
  }))
};
const labelsSchemaProps = {
  visible: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: true,
    meta: {
      description: 'Whether to show axis labels'
    }
  })),
  orientation: _configSchema.schema.maybe(_enums.builderEnums.orientation({
    defaultValue: 'horizontal',
    meta: {
      description: 'Orientation of the axis labels'
    }
  }))
};
const simpleLabelsSchema = _configSchema.schema.object((0, _lodash.omit)(labelsSchemaProps, 'orientation'));
const heatmapSharedStateSchema = {
  type: _configSchema.schema.literal('heatmap'),
  legend: _configSchema.schema.maybe(_configSchema.schema.object(legendSchemaProps, {
    meta: {
      description: 'Legend configuration'
    }
  })),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  axes: _configSchema.schema.maybe(_configSchema.schema.object({
    x: _configSchema.schema.maybe(_configSchema.schema.object({
      title: _configSchema.schema.maybe(_configSchema.schema.object(_shared.axisTitleSchemaProps)),
      labels: _configSchema.schema.maybe(_configSchema.schema.object(labelsSchemaProps))
    })),
    y: _configSchema.schema.maybe(_configSchema.schema.object({
      title: _configSchema.schema.maybe(_configSchema.schema.object(_shared.axisTitleSchemaProps)),
      labels: _configSchema.schema.maybe(simpleLabelsSchema)
    }))
  }, {
    meta: {
      description: 'Axis configuration for X and Y axes'
    }
  })),
  cells: _configSchema.schema.maybe(_configSchema.schema.object({
    labels: _configSchema.schema.maybe(_configSchema.schema.object({
      visible: _configSchema.schema.maybe(_configSchema.schema.boolean({
        defaultValue: false,
        meta: {
          description: 'Whether to show cell labels'
        }
      }))
    }))
  }, {
    meta: {
      description: 'Cells configuration'
    }
  }))
};
const heatmapAxesStateSchemaProps = {
  xAxis: _bucket_ops.bucketOperationDefinitionSchema,
  yAxis: _configSchema.schema.maybe(_bucket_ops.bucketOperationDefinitionSchema)
};
const heatmapAxesStateESQLSchemaProps = {
  xAxis: _metric_ops.esqlColumnSchema,
  yAxis: _configSchema.schema.maybe(_metric_ops.esqlColumnSchema)
};
const heatmapStateMetricOptionsSchemaProps = {
  color: _configSchema.schema.maybe(_color.colorByValueSchema)
};
const heatmapStateSchemaNoESQL = exports.heatmapStateSchemaNoESQL = _configSchema.schema.object({
  ...heatmapSharedStateSchema,
  ...heatmapAxesStateSchemaProps,
  ..._shared.dslOnlyPanelInfoSchema,
  ..._dataset.datasetSchema,
  metric: (0, _shared2.mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps)(_configSchema.schema.object(heatmapStateMetricOptionsSchemaProps))
});
const heatmapStateSchemaESQL = exports.heatmapStateSchemaESQL = _configSchema.schema.object({
  ...heatmapSharedStateSchema,
  ...heatmapAxesStateESQLSchemaProps,
  ..._dataset.datasetEsqlTableSchema,
  metric: _configSchema.schema.allOf([_configSchema.schema.object(heatmapStateMetricOptionsSchemaProps), _metric_ops.esqlColumnSchema])
});
const heatmapStateSchema = exports.heatmapStateSchema = _configSchema.schema.oneOf([heatmapStateSchemaNoESQL, heatmapStateSchemaESQL]);