"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gaugeStateSchemaNoESQL = exports.gaugeStateSchemaESQL = exports.gaugeStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _metric_ops = require("../metric_ops");
var _color = require("../color");
var _dataset = require("../dataset");
var _shared = require("../shared");
var _shared2 = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const gaugeStateSharedOptionsSchema = {
  shape: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.object({
    type: _configSchema.schema.literal('bullet'),
    direction: _configSchema.schema.oneOf([_configSchema.schema.literal('horizontal'), _configSchema.schema.literal('vertical')], {
      defaultValue: 'horizontal'
    })
  }), _configSchema.schema.object({
    type: _configSchema.schema.oneOf([_configSchema.schema.literal('circle'), _configSchema.schema.literal('semiCircle'), _configSchema.schema.literal('arc')])
  })], {
    defaultValue: {
      type: 'bullet',
      direction: 'horizontal'
    }
  }))
};
const gaugeStateMetricInnerNoESQLOpsSchema = {
  /**
   * Minimum value for the gauge
   * Note: label, format and other visual options are ignored
   */
  min: _configSchema.schema.maybe(_metric_ops.metricOperationDefinitionSchema),
  /**
   * Maximum value for the gauge
   * Note: label, format and other visual options are ignored
   */
  max: _configSchema.schema.maybe(_metric_ops.metricOperationDefinitionSchema),
  /**
   * Goal value for the gauge
   * Note: label, format and other visual options are ignored
   */
  goal: _configSchema.schema.maybe(_metric_ops.metricOperationDefinitionSchema)
};
const gaugeStateMetricInnerESQLOpsSchema = {
  /**
   * Minimum value for the gauge
   * Note: label, format and other visual options are ignored
   */
  min: _configSchema.schema.maybe(_metric_ops.esqlColumnSchema),
  /**
   * Maximum value for the gauge
   * Note: label, format and other visual options are ignored
   */
  max: _configSchema.schema.maybe(_metric_ops.esqlColumnSchema),
  /**
   * Goal value for the gauge
   * Note: label, format and other visual options are ignored
   */
  goal: _configSchema.schema.maybe(_metric_ops.esqlColumnSchema)
};
const gaugeStateMetricOptionsSchema = {
  /**
   * Title (overrides label on chart panel, but not in table)
   */
  title: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Title'
    }
  })),
  /**
   * Whether to hide the title
   */
  hide_title: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Hide title'
    },
    defaultValue: false
  })),
  /**
   * Sub title
   */
  sub_title: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Sub title'
    }
  })),
  /**
   * Color configuration
   */
  color: _configSchema.schema.maybe(_color.colorByValueSchema),
  /**
   * Tick marks configuration
   */
  ticks: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('auto'), _configSchema.schema.literal('bands'), _configSchema.schema.literal('hidden')], {
    defaultValue: 'auto'
  }))
};
const gaugeStateSchemaNoESQL = exports.gaugeStateSchemaNoESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('gauge'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.dslOnlyPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetSchema,
  ...gaugeStateSharedOptionsSchema,
  /**
   * Primary value configuration, must define operation.
   */
  metric: (0, _shared2.mergeAllMetricsWithChartDimensionSchema)(_configSchema.schema.object({
    ...gaugeStateMetricOptionsSchema,
    ...gaugeStateMetricInnerNoESQLOpsSchema
  }))
});
const gaugeStateSchemaESQL = exports.gaugeStateSchemaESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('gauge'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetEsqlTableSchema,
  ...gaugeStateSharedOptionsSchema,
  /**
   * Primary value configuration, must define operation.
   */
  metric: _configSchema.schema.allOf([_configSchema.schema.object({
    ..._metric_ops.genericOperationOptionsSchema,
    ...gaugeStateMetricOptionsSchema,
    ...gaugeStateMetricInnerESQLOpsSchema
  }), _metric_ops.esqlColumnSchema])
});
const gaugeStateSchema = exports.gaugeStateSchema = _configSchema.schema.oneOf([gaugeStateSchemaNoESQL, gaugeStateSchemaESQL]);