"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensLayerTypeTabDisplayName = getLensLayerTypeTabDisplayName;
exports.lensLayerTypeTabDisplayNames = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Mapping of lens layer types to tab display names
const lensLayerTypeTabDisplayNames = exports.lensLayerTypeTabDisplayNames = {
  data: _i18n.i18n.translate('xpack.lens.layerTypes.tabDisplayName.data', {
    defaultMessage: 'Data layer'
  }),
  referenceLine: _i18n.i18n.translate('xpack.lens.layerTypes.tabDisplayName.referenceLine', {
    defaultMessage: 'Reference line'
  }),
  annotations: _i18n.i18n.translate('xpack.lens.layerTypes.tabDisplayName.annotations', {
    defaultMessage: 'Annotation'
  }),
  metricTrendline: _i18n.i18n.translate('xpack.lens.layerTypes.tabDisplayName.metricTrendline', {
    defaultMessage: 'Metric trendline'
  }),
  unknown: _i18n.i18n.translate('xpack.lens.layerTypes.tabDisplayName.unknown', {
    defaultMessage: 'Unknown layer'
  })
};

// Utility function to get the tab display name for a layer type
function getLensLayerTypeTabDisplayName(layerType, layerTypeCount, countForLayerId) {
  var _ref;
  const baseLabel = (_ref = layerType && lensLayerTypeTabDisplayNames[layerType]) !== null && _ref !== void 0 ? _ref : lensLayerTypeTabDisplayNames.unknown;
  return _i18n.i18n.translate('xpack.lens.layerTypes.tabDisplayName.withCount', {
    defaultMessage: '{baseLabel}{displayCount, select, true { {countForLayerId}} other {}}',
    values: {
      baseLabel,
      displayCount: (layerTypeCount !== null && layerTypeCount !== void 0 ? layerTypeCount : 0) > 1,
      countForLayerId
    }
  });
}