"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreeViewContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _tree_nav = require("./tree_nav");
var _breadcrumb = require("./breadcrumb");
var _contexts = require("./contexts");
var _empty_state = require("./empty_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/kubernetes_security/public/components/tree_view_container/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TreeViewContainer = ({
  globalFilter,
  renderSessionsView,
  indexPattern
}) => {
  return /*#__PURE__*/_react.default.createElement(_contexts.TreeViewContextProvider, {
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(TreeViewContainerComponent, {
    renderSessionsView: renderSessionsView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }));
};
exports.TreeViewContainer = TreeViewContainer;
const TreeViewContainerComponent = ({
  renderSessionsView
}) => {
  const styles = (0, _styles.useStyles)();
  const {
    treeNavSelection,
    sessionViewFilter,
    onTreeNavSelect,
    noResults
  } = (0, _contexts.useTreeViewContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    direction: "row",
    hasBorder: true,
    borderRadius: "m",
    css: styles.outerPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, noResults && /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    hidden: noResults,
    color: "subdued",
    grow: false,
    css: styles.navPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_tree_nav.TreeNav, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    hidden: noResults,
    css: styles.sessionsPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
    treeNavSelection: treeNavSelection,
    onSelect: onTreeNavSelect,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }), renderSessionsView(sessionViewFilter)));
};