"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALUE_TEST_ID = exports.TOOLTIP_TEST_ID = exports.LOADING_TEST_ID = exports.CountWidget = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _add_commas_to_number = require("../../utils/add_commas_to_number");
var _add_timerange_and_default_filter_to_query = require("../../utils/add_timerange_and_default_filter_to_query");
var _hooks = require("./hooks");
var _helpers = require("./helpers");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/kubernetes_security/public/components/count_widget/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOADING_TEST_ID = exports.LOADING_TEST_ID = 'kubernetesSecurity:countWidgetLoading';
const TOOLTIP_TEST_ID = exports.TOOLTIP_TEST_ID = 'kubernetesSecurity:countWidgetTooltip';
const VALUE_TEST_ID = exports.VALUE_TEST_ID = 'kubernetesSecurity:countWidgetValue';
const CountWidget = ({
  title,
  widgetKey,
  indexPattern,
  globalFilter,
  groupedBy
}) => {
  const styles = (0, _styles.useStyles)();
  const filterQueryWithTimeRange = (0, _react.useMemo)(() => {
    let globalFilterModified = globalFilter.filterQuery;
    if (widgetKey === _constants.COUNT_WIDGET_KEY_PODS) {
      globalFilterModified = (0, _helpers.addResourceTypeToFilterQuery)(globalFilter.filterQuery, 'pod');
    }
    return (0, _add_timerange_and_default_filter_to_query.addTimerangeAndDefaultFilterToQuery)(globalFilterModified, globalFilter.startDate, globalFilter.endDate);
  }, [globalFilter.filterQuery, globalFilter.startDate, globalFilter.endDate, widgetKey]);
  const {
    data,
    isLoading
  } = (0, _hooks.useFetchCountWidgetData)(widgetKey, filterQueryWithTimeRange, groupedBy, indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.title);
  const countValue = (0, _react.useMemo)(() => {
    return data ? data === null || data === void 0 ? void 0 : data.pages[0] : 0;
  }, [data]);
  const formattedNumber = (0, _react.useMemo)(() => {
    return (0, _helpers.numberFormatter)(countValue);
  }, [countValue]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isLoading ? null : (0, _add_commas_to_number.addCommasToNumber)(countValue),
    "data-test-subj": TOOLTIP_TEST_ID,
    "aria-label": "Info",
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: styles.dataInfo,
    "data-test-subj": VALUE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": LOADING_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }) : formattedNumber)));
};
exports.CountWidget = CountWidget;