"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QUERY_KEY_PROCESS_EVENTS = exports.QUERY_KEY_PERCENT_WIDGET = exports.QUERY_KEY_COUNT_WIDGET = exports.QUERY_KEY_CONTAINER_NAME_WIDGET = exports.QUERY_KEY_AGENT_ID = exports.ORCHESTRATOR_RESOURCE_ID = exports.ORCHESTRATOR_NAMESPACE = exports.ORCHESTRATOR_CLUSTER_NAME = exports.ORCHESTRATOR_CLUSTER_ID = exports.MULTI_TERMS_AGGREGATE_ROUTE = exports.LOCAL_STORAGE_TREE_NAV_KEY = exports.LOCAL_STORAGE_HIDE_WIDGETS_KEY = exports.KUBERNETES_TITLE = exports.KUBERNETES_PATH = exports.ENTRY_LEADER_USER_ID = exports.ENTRY_LEADER_INTERACTIVE = exports.ENTRY_LEADER_ENTITY_ID = exports.DEFAULT_FILTER_QUERY = exports.DEFAULT_FILTER = exports.CURRENT_API_VERSION = exports.COUNT_WIDGET_KEY_PODS = exports.COUNT_WIDGET_KEY_NODES = exports.COUNT_WIDGET_KEY_NAMESPACE = exports.COUNT_WIDGET_KEY_CONTAINER_IMAGES = exports.COUNT_WIDGET_KEY_CLUSTERS = exports.COUNT_ROUTE = exports.CONTAINER_IMAGE_NAME = exports.CLOUD_INSTANCE_NAME = exports.AGGREGATE_ROUTE = exports.AGGREGATE_PAGE_SIZE = exports.AGGREGATE_MAX_BUCKETS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KUBERNETES_PATH = exports.KUBERNETES_PATH = '/kubernetes';
const KUBERNETES_TITLE = exports.KUBERNETES_TITLE = 'Kubernetes';
const LOCAL_STORAGE_HIDE_WIDGETS_KEY = exports.LOCAL_STORAGE_HIDE_WIDGETS_KEY = 'kubernetesSecurity:shouldHideWidgets';
const LOCAL_STORAGE_TREE_NAV_KEY = exports.LOCAL_STORAGE_TREE_NAV_KEY = 'kubernetesSecurity:treeNavSelection';
const CURRENT_API_VERSION = exports.CURRENT_API_VERSION = '1';
const AGGREGATE_ROUTE = exports.AGGREGATE_ROUTE = '/internal/kubernetes_security/aggregate';
const COUNT_ROUTE = exports.COUNT_ROUTE = '/internal/kubernetes_security/count';
const MULTI_TERMS_AGGREGATE_ROUTE = exports.MULTI_TERMS_AGGREGATE_ROUTE = '/internal/kubernetes_security/multi_terms_aggregate';
const AGGREGATE_PAGE_SIZE = exports.AGGREGATE_PAGE_SIZE = 10;

// so, bucket sort can only page through what we request at the top level agg, which means there is a ceiling to how many aggs we can page through.
// we should also test this approach at scale.
const AGGREGATE_MAX_BUCKETS = exports.AGGREGATE_MAX_BUCKETS = 2000;

// react-query caching keys
const QUERY_KEY_PERCENT_WIDGET = exports.QUERY_KEY_PERCENT_WIDGET = 'kubernetesSecurityPercentWidget';
const QUERY_KEY_COUNT_WIDGET = exports.QUERY_KEY_COUNT_WIDGET = 'kubernetesSecurityCountWidget';
const QUERY_KEY_CONTAINER_NAME_WIDGET = exports.QUERY_KEY_CONTAINER_NAME_WIDGET = 'kubernetesSecurityContainerNameWidget';
const QUERY_KEY_PROCESS_EVENTS = exports.QUERY_KEY_PROCESS_EVENTS = 'kubernetesSecurityProcessEvents';
const QUERY_KEY_AGENT_ID = exports.QUERY_KEY_AGENT_ID = 'kubernetesSecurityAgentId';

// ECS fields
const ENTRY_LEADER_INTERACTIVE = exports.ENTRY_LEADER_INTERACTIVE = 'process.entry_leader.interactive';
const ENTRY_LEADER_USER_ID = exports.ENTRY_LEADER_USER_ID = 'process.entry_leader.user.id';
const ENTRY_LEADER_ENTITY_ID = exports.ENTRY_LEADER_ENTITY_ID = 'process.entry_leader.entity_id';
const ORCHESTRATOR_CLUSTER_ID = exports.ORCHESTRATOR_CLUSTER_ID = 'orchestrator.cluster.id';
const ORCHESTRATOR_CLUSTER_NAME = exports.ORCHESTRATOR_CLUSTER_NAME = 'orchestrator.cluster.name';
const ORCHESTRATOR_NAMESPACE = exports.ORCHESTRATOR_NAMESPACE = 'orchestrator.namespace';
const CLOUD_INSTANCE_NAME = exports.CLOUD_INSTANCE_NAME = 'cloud.instance.name';
const ORCHESTRATOR_RESOURCE_ID = exports.ORCHESTRATOR_RESOURCE_ID = 'orchestrator.resource.name';
const CONTAINER_IMAGE_NAME = exports.CONTAINER_IMAGE_NAME = 'container.image.name';
const COUNT_WIDGET_KEY_CLUSTERS = exports.COUNT_WIDGET_KEY_CLUSTERS = 'CountClustersWidget';
const COUNT_WIDGET_KEY_NAMESPACE = exports.COUNT_WIDGET_KEY_NAMESPACE = 'CountNamespaceWidgets';
const COUNT_WIDGET_KEY_NODES = exports.COUNT_WIDGET_KEY_NODES = 'CountNodesWidgets';
const COUNT_WIDGET_KEY_PODS = exports.COUNT_WIDGET_KEY_PODS = 'CountPodsWidgets';
const COUNT_WIDGET_KEY_CONTAINER_IMAGES = exports.COUNT_WIDGET_KEY_CONTAINER_IMAGES = 'CountContainerImagesWidgets';
const DEFAULT_FILTER = exports.DEFAULT_FILTER = {
  bool: {
    should: [{
      exists: {
        field: ORCHESTRATOR_CLUSTER_ID
      }
    }],
    minimum_should_match: 1
  }
};
const DEFAULT_FILTER_QUERY = exports.DEFAULT_FILTER_QUERY = JSON.stringify({
  bool: {
    must: [],
    filter: [DEFAULT_FILTER],
    should: [],
    must_not: []
  }
});