"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCollectorFetch = createCollectorFetch;
exports.registerManagementUsageCollector = registerManagementUsageCollector;
var _constants = require("../../../common/constants");
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * These config keys should be redacted from any usage data, they are only used for implementation details of the config saved object.
 */
const CONFIG_KEYS_TO_REDACT = ['buildNum', 'isDefaultIndexMigrated'];
function createCollectorFetch(getUiSettingsClient) {
  return async function fetchUsageStats() {
    const uiSettingsClient = getUiSettingsClient();
    if (!uiSettingsClient) {
      return;
    }
    const userProvided = await uiSettingsClient.getUserProvided();
    const modifiedEntries = Object.entries(userProvided).filter(([key]) => !CONFIG_KEYS_TO_REDACT.includes(key)).reduce((obj, [key, {
      userValue
    }]) => {
      const sensitive = uiSettingsClient.isSensitive(key);
      obj[key] = sensitive ? _constants.REDACTED_KEYWORD : userValue;
      return obj;
    }, {});
    // TODO: It would be Partial<UsageStats>, but the telemetry-tools for the schema extraction still does not support it. We need to fix it before setting the right Partial<UsageStats> type
    return modifiedEntries;
  };
}
function registerManagementUsageCollector(usageCollection, getUiSettingsClient) {
  const collector = usageCollection.makeUsageCollector({
    type: 'stack_management',
    isReady: () => typeof getUiSettingsClient() !== 'undefined',
    fetch: createCollectorFetch(getUiSettingsClient),
    schema: _schema.stackManagementSchema
  });
  usageCollection.registerCollector(collector);
}