"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserInterceptRunPersistenceService = void 0;
var Rx = _interopRequireWildcard(require("rxjs"));
var _apmRum = require("@elastic/apm-rum");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @description provides utils to read and update information about the last interaction with a given intercept trigger.
 */
class UserInterceptRunPersistenceService {
  start(http) {
    return {
      getUserTriggerData$: this.userInterceptRunId.bind(this, http),
      updateUserTriggerData: this.persistInterceptRunInteraction.bind(this, http)
    };
  }
  userInterceptRunId(http, triggerId) {
    return Rx.from(http.get(_constants.TRIGGER_USER_INTERACTION_METADATA_API_ROUTE.replace('{triggerId}', triggerId))).pipe(Rx.catchError(error => {
      _apmRum.apm.captureError(error, {
        labels: {
          triggerId,
          errorContext: 'userInterceptRunId'
        }
      });
      // Return a default value to prevent the stream from breaking
      // This allows the intercept to continue functioning even if the API call fails
      return Rx.of({
        lastInteractedInterceptId: null
      });
    }));
  }
  persistInterceptRunInteraction(http, triggerId, runId) {
    return Rx.from(http.post(_constants.TRIGGER_USER_INTERACTION_METADATA_API_ROUTE.replace('{triggerId}', triggerId), {
      body: JSON.stringify({
        lastInteractedInterceptId: runId
      })
    })).pipe(Rx.catchError(error => {
      _apmRum.apm.captureError(error, {
        labels: {
          triggerId,
          runId: String(runId),
          errorContext: 'persistInterceptRunInteraction'
        }
      });
      // Return empty observable to gracefully handle the error
      // This prevents the update failure from breaking the user experience
      return Rx.EMPTY;
    }));
  }
}
exports.UserInterceptRunPersistenceService = UserInterceptRunPersistenceService;