"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterHealth = ClusterHealth;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _gradient = require("./gradient");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/views/requests/components/details/clusters_view/clusters_health/cluster_health.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const defaultTextProps = {
  size: 'xs',
  color: 'subdued'
};
function ClusterHealth({
  count,
  status,
  textProps = defaultTextProps
}) {
  const healthHexCodes = (0, _gradient.useHealthHexCodes)();
  if (typeof count === 'number' && count === 0) {
    return null;
  }
  let color = 'subdued';
  let statusLabel = status;
  if (status === 'successful') {
    color = healthHexCodes.successful;
    statusLabel = _i18n.i18n.translate('inspector.requests.clusters.successfulLabel', {
      defaultMessage: 'successful'
    });
  } else if (status === 'partial') {
    color = healthHexCodes.partial;
    statusLabel = _i18n.i18n.translate('inspector.requests.clusters.partialLabel', {
      defaultMessage: 'partial'
    });
  } else if (status === 'skipped') {
    color = healthHexCodes.skipped;
    statusLabel = _i18n.i18n.translate('inspector.requests.clusters.skippedLabel', {
      defaultMessage: 'skipped'
    });
  } else if (status === 'failed') {
    color = healthHexCodes.failed;
    statusLabel = _i18n.i18n.translate('inspector.requests.clusters.failedLabel', {
      defaultMessage: 'failed'
    });
  }
  const label = typeof count === 'number' ? `${count} ${statusLabel}` : statusLabel;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, (0, _extends2.default)({}, textProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), label));
}