"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findFirstEuiComponent = void 0;
var _utils = require("../utils");
var _get_fiber_type = require("./get_fiber_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Find the first EUI component in the {@link ReactFiberNode React Fiber node} owner chain.
 * @param {ReactFiberNode} fiber {@link ReactFiberNode React Fiber node} to start the search from.
 * @return {string | null} The EUI component display name, or null if none is found.
 */
const findFirstEuiComponent = fiber => {
  let fiberCursor = fiber;
  while (fiberCursor) {
    const type = (0, _get_fiber_type.getFiberType)(fiberCursor);
    if (type && (0, _utils.isEuiMainComponent)(type) && !(0, _utils.isExcludedComponent)(type)) {
      return type;
    }
    fiberCursor = fiberCursor._debugOwner;
  }
  return null;
};
exports.findFirstEuiComponent = findFirstEuiComponent;