"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInputControlVisFn = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createInputControlVisFn = () => ({
  name: 'input_control_vis',
  type: 'render',
  inputTypes: [],
  help: _i18n.i18n.translate('inputControl.function.help', {
    defaultMessage: 'Input control visualization'
  }),
  args: {
    visConfig: {
      types: ['string'],
      default: '"{}"',
      help: ''
    }
  },
  fn(input, args) {
    const params = JSON.parse(args.visConfig);
    return {
      type: 'render',
      as: 'input_control_vis',
      value: {
        visType: 'input_control_vis',
        visConfig: params
      }
    };
  }
});
exports.createInputControlVisFn = createInputControlVisFn;