"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.infraCustomDashboardsSavedObjectType = exports.INFRA_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This feature is deprecated and will be removed in https://github.com/elastic/kibana/issues/220340
const INFRA_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE = exports.INFRA_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE = 'infra-custom-dashboards';
const properties = {
  assetType: {
    type: 'keyword'
  },
  dashboardSavedObjectId: {
    type: 'keyword'
  },
  dashboardFilterAssetIdEnabled: {
    type: 'boolean'
  }
};
const infraCustomDashboardsSavedObjectType = exports.infraCustomDashboardsSavedObjectType = {
  name: INFRA_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE,
  hidden: false,
  namespaceType: 'multiple',
  mappings: {
    dynamic: false,
    properties
  },
  management: {
    importableAndExportable: true,
    icon: 'infraApp',
    getTitle: () => _i18n.i18n.translate('xpack.infra.infraAssetCustomDashboards.', {
      defaultMessage: 'Infrastructure Asset Custom Dashboards'
    })
  },
  modelVersions: {
    '1': {
      changes: [],
      schemas: {
        create: _configSchema.schema.object({
          dashboardIdList: _configSchema.schema.arrayOf(_configSchema.schema.string()),
          assetType: _configSchema.schema.string(),
          kuery: _configSchema.schema.maybe(_configSchema.schema.string())
        })
      }
    },
    '2': {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          dashboardSavedObjectId: {
            type: 'keyword'
          },
          dashboardFilterAssetIdEnabled: {
            type: 'boolean'
          }
        }
      }, {
        type: 'mappings_deprecation',
        deprecatedMappings: ['dashboardIdList', 'kuery']
      }],
      schemas: {
        create: _configSchema.schema.object({
          dashboardSavedObjectId: _configSchema.schema.string(),
          assetType: _configSchema.schema.string(),
          dashboardFilterAssetIdEnabled: _configSchema.schema.boolean()
        })
      }
    }
  }
};