"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInventoryModelAggregations = exports.getDocumentsFilter = void 0;
var _common = require("@kbn/metrics-data-access-plugin/common");
var _common2 = require("@kbn/apm-data-access-plugin/common");
var _document_type = require("@kbn/apm-data-access-plugin/server/lib/helpers/create_es_client/document_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApmDocumentsFilter = async ({
  apmDataAccessServices,
  apmDocumentSources,
  start,
  end,
  schema
}) => {
  const {
    preferredSource,
    documentTypeConfig
  } = apmDataAccessServices.getDocumentTypeConfig({
    start,
    end,
    documentTypes: [_common2.ApmDocumentType.TransactionMetric],
    documentSources: apmDocumentSources
  });
  const query = 'getQuery' in documentTypeConfig ? documentTypeConfig.getQuery(preferredSource.source.rollupInterval) : undefined;
  const schemaFilter = (0, _document_type.getDatasetFilterForSchema)(preferredSource.source.documentType, preferredSource.source.rollupInterval, schema);
  return {
    bool: {
      filter: query ? [query, ...schemaFilter] : schemaFilter
    }
  };
};
const getDocumentsFilter = async ({
  apmDataAccessServices,
  apmDocumentSources,
  from,
  to,
  schema
}) => {
  var _inventoryModel$nodeF, _inventoryModel$nodeF2;
  const inventoryModel = (0, _common.findInventoryModel)('host');
  const filters = (_inventoryModel$nodeF = (_inventoryModel$nodeF2 = inventoryModel.nodeFilter) === null || _inventoryModel$nodeF2 === void 0 ? void 0 : _inventoryModel$nodeF2.call(inventoryModel, {
    schema
  })) !== null && _inventoryModel$nodeF !== void 0 ? _inventoryModel$nodeF : [];
  const apmDocumentsFilter = apmDataAccessServices && apmDocumentSources ? await getApmDocumentsFilter({
    apmDataAccessServices,
    apmDocumentSources,
    start: from,
    end: to,
    schema
  }) : undefined;
  if (apmDocumentsFilter) {
    filters.push(apmDocumentsFilter);
  }
  return filters;
};
exports.getDocumentsFilter = getDocumentsFilter;
const getInventoryModelAggregations = async (assetType, metrics, schema) => {
  const inventoryModel = (0, _common.findInventoryModel)(assetType);
  const aggregations = await inventoryModel.metrics.getAggregations({
    schema
  });
  return metrics.reduce((acc, metric) => {
    const metricAgg = aggregations.get(metric);
    if (metricAgg) {
      Object.assign(acc, metricAgg);
    }
    return acc;
  }, {});
};
exports.getInventoryModelAggregations = getInventoryModelAggregations;