"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getThresholds = exports.getEvaluationValues = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEvaluationValues = (alertResults, group) => {
  return alertResults.reduce((acc, result) => {
    if (result[group]) {
      acc.push(result[group].currentValue);
    }
    return acc;
  }, []);
};
exports.getEvaluationValues = getEvaluationValues;
const getThresholds = criteria => {
  let hasMultipleThresholdComparator = false;
  const thresholds = criteria.map(c => c.threshold).reduce((acc, t) => {
    if (t.length !== 1) {
      hasMultipleThresholdComparator = true;
      return acc;
    }
    return acc.concat(t[0]);
  }, []);

  // We don't save threshold if at least one of the comparators is a multiple threshold one such as 'in between'
  if (hasMultipleThresholdComparator) return undefined;
  return thresholds;
};
exports.getThresholds = getThresholds;