"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolvePersistedDataView = exports.resolveDataView = exports.resolveAdHocDataView = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildResolvedDataView = dataViewReference => {
  var _dataViewReference$ti, _dataViewReference$fi;
  return {
    indices: dataViewReference.getIndexPattern(),
    timeFieldName: (_dataViewReference$ti = dataViewReference.timeFieldName) !== null && _dataViewReference$ti !== void 0 ? _dataViewReference$ti : _constants.TIMESTAMP_FIELD,
    fields: (_dataViewReference$fi = dataViewReference.fields) !== null && _dataViewReference$fi !== void 0 ? _dataViewReference$fi : [],
    dataViewReference
  };
};
const resolveDataView = async ({
  dataViewId,
  dataViewsService
}) => {
  try {
    return await resolvePersistedDataView({
      dataViewsService,
      dataViewId
    });
  } catch {
    return resolveAdHocDataView({
      dataViewsService,
      dataViewId,
      attributes: {
        timeFieldName: _constants.TIMESTAMP_FIELD
      }
    });
  }
};
exports.resolveDataView = resolveDataView;
const resolvePersistedDataView = async ({
  dataViewsService,
  dataViewId
}) => {
  const dataView = await dataViewsService.get(dataViewId, false);
  return buildResolvedDataView(dataView);
};
exports.resolvePersistedDataView = resolvePersistedDataView;
const resolveAdHocDataView = async ({
  dataViewsService,
  dataViewId,
  attributes
}) => {
  const {
    name,
    timeFieldName
  } = attributes;
  const dataViewReference = await dataViewsService.get(dataViewId, false, true).catch(() => {
    return dataViewsService.create({
      id: dataViewId,
      name,
      title: dataViewId,
      timeFieldName
    }, false, false);
  });
  return buildResolvedDataView(dataViewReference);
};
exports.resolveAdHocDataView = resolveAdHocDataView;