"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModeSwitcher = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/metric_control/mode_switcher.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ModeSwitcher = ({
  onSave,
  onEditCancel,
  onEdit,
  onAdd,
  mode,
  customMetrics,
  disableAdd = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (['editMetric', 'addMetric'].includes(mode)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      borderTop: `${euiTheme.border.thin} solid ${euiTheme.border.color}`,
      padding: 12
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, mode === 'edit' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraModeSwitcherCancelButton",
    size: "s",
    flush: "left",
    onClick: onEditCancel,
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.cancelAriaLabel', {
      defaultMessage: 'Cancel edit mode'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.modeSwitcher.cancel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraModeSwitcherSaveButton",
    onClick: onSave,
    size: "s",
    fill: true,
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.saveButtonAriaLabel', {
      defaultMessage: 'Save changes to custom metrics'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.modeSwitcher.saveButton",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 17
    }
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraModeSwitcherEditButton",
    size: "s",
    flush: "left",
    onClick: onEdit,
    disabled: customMetrics.length === 0,
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.editAriaLabel', {
      defaultMessage: 'Edit custom metrics'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.modeSwitcher.edit",
    defaultMessage: "Edit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: disableAdd ? _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.addDisabledTooltip', {
      defaultMessage: 'Maximum number of {maxMetrics} metrics reached.',
      values: {
        maxMetrics: _constants.SNAPSHOT_API_MAX_METRICS
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraModeSwitcherAddMetricButton",
    onClick: onAdd,
    disabled: disableAdd,
    size: "s",
    flush: "right",
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.addMetricAriaLabel', {
      defaultMessage: 'Add custom metric'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.modeSwitcher.addMetric",
    defaultMessage: "Add metric",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 19
    }
  })))))));
};
exports.ModeSwitcher = ModeSwitcher;