"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendControls = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _types = require("../../../../../common/inventory/types");
var _get_color_palette = require("../../lib/get_color_palette");
var _convert_bounds_to_percents = require("../../lib/convert_bounds_to_percents");
var _color_label = require("./color_label");
var _palette_preview = require("./palette_preview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/legend_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PALETTE_NAMES = ['temperature', 'status', 'cool', 'warm', 'positive', 'negative'];
const PALETTE_OPTIONS = PALETTE_NAMES.map(name => ({
  text: _types.PALETTES[name],
  value: name
}));
const LegendControls = ({
  autoBounds,
  boundsOverride,
  onChange,
  dataBounds,
  options
}) => {
  const [isPopoverOpen, setPopoverState] = (0, _react.useState)(false);
  const [draftAuto, setDraftAuto] = (0, _react.useState)(autoBounds);
  const [draftLegend, setLegendOptions] = (0, _react.useState)(options);
  const [draftBounds, setDraftBounds] = (0, _react.useState)((0, _convert_bounds_to_percents.convertBoundsToPercents)(boundsOverride)); // should come from bounds prop

  (0, _react.useEffect)(() => {
    if (draftAuto) {
      setDraftBounds((0, _convert_bounds_to_percents.convertBoundsToPercents)(dataBounds));
    }
  }, [autoBounds, dataBounds, draftAuto, onChange, options]);
  const buttonComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "color",
    color: "text",
    display: "base",
    size: "s",
    "aria-label": _i18n.i18n.translate('xpack.infra.legendControls.buttonLabel', {
      defaultMessage: 'configure legend'
    }),
    onClick: () => setPopoverState(true),
    "data-test-subj": "openLegendControlsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  });
  const handleAutoChange = (0, _react.useCallback)(e => {
    const auto = e.target.checked;
    setDraftAuto(auto);
    if (!auto) {
      setDraftBounds((0, _convert_bounds_to_percents.convertBoundsToPercents)(boundsOverride));
    }
  }, [boundsOverride]);
  const handleReverseColors = (0, _react.useCallback)(e => {
    setLegendOptions(previous => ({
      ...previous,
      reverseColors: e.target.checked
    }));
  }, [setLegendOptions]);
  const handleMaxBounds = (0, _react.useCallback)(e => {
    const value = parseFloat(e.currentTarget.value);
    // Auto correct the max to be one larger then the min OR 100
    const max = value <= draftBounds.min ? draftBounds.min + 1 : value > 100 ? 100 : value;
    setDraftBounds({
      ...draftBounds,
      max
    });
  }, [draftBounds]);
  const handleMinBounds = (0, _react.useCallback)(e => {
    const value = parseFloat(e.currentTarget.value);
    // Auto correct the min to be one smaller then the max OR ZERO
    const min = value >= draftBounds.max ? draftBounds.max - 1 : value < 0 ? 0 : value;
    setDraftBounds({
      ...draftBounds,
      min
    });
  }, [draftBounds]);
  const handleApplyClick = (0, _react.useCallback)(() => {
    onChange({
      auto: draftAuto,
      bounds: {
        min: draftBounds.min / 100,
        max: draftBounds.max / 100
      },
      legend: draftLegend
    });
    setPopoverState(false);
  }, [onChange, draftAuto, draftBounds, draftLegend]);
  const handleCancelClick = (0, _react.useCallback)(() => {
    setDraftBounds((0, _convert_bounds_to_percents.convertBoundsToPercents)(boundsOverride));
    setDraftAuto(autoBounds);
    setLegendOptions(options);
    setPopoverState(false);
  }, [autoBounds, boundsOverride, options]);
  const handleStepsChange = (0, _react.useCallback)(e => {
    const steps = parseInt(e.target.value, 10);
    setLegendOptions(previous => ({
      ...previous,
      steps
    }));
  }, [setLegendOptions]);
  const handlePaletteChange = (0, _react.useCallback)(e => {
    const palette = e.target.value;
    setLegendOptions(previous => ({
      ...previous,
      palette
    }));
  }, [setLegendOptions]);
  const commited = draftAuto === autoBounds && boundsOverride.min * 100 === draftBounds.min && boundsOverride.max * 100 === draftBounds.max && options.steps === draftLegend.steps && options.reverseColors === draftLegend.reverseColors && options.palette === draftLegend.palette;
  const boundsValidRange = draftBounds.min < draftBounds.max;
  const paletteColors = (0, _get_color_palette.getColorPalette)(draftLegend.palette, draftLegend.steps, draftLegend.reverseColors);
  const errors = !boundsValidRange ? [_i18n.i18n.translate('xpack.infra.legendControls.boundRangeError', {
    defaultMessage: 'Minimum must be smaller than the maximum'
  })] : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: handleCancelClick,
    id: "legendControls",
    button: buttonComponent,
    anchorPosition: "leftCenter",
    "data-test-subj": "legendControls",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.infra.legendControls.legendOptionsPopoverTitleLabel', {
    defaultMessage: 'Legend Options'
  })), /*#__PURE__*/_react.default.createElement(StyledEuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.infra.legendControls.colorPaletteLabel', {
      defaultMessage: 'Color palette'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.infra.legendControls.colorPalette.ariaLabel', {
      defaultMessage: 'Color palette selection'
    }),
    options: PALETTE_OPTIONS,
    value: draftLegend.palette,
    id: "palette",
    onChange: handlePaletteChange,
    compressed: true,
    "data-test-subj": "legendControlsPalette",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_palette_preview.PalettePreview, {
    palette: draftLegend.palette,
    steps: draftLegend.steps,
    reverse: draftLegend.reverseColors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.infra.legendControls.stepsLabel', {
      defaultMessage: 'Number of colors'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    id: "steps",
    min: 2,
    max: 18,
    step: 1,
    value: draftLegend.steps,
    onChange: handleStepsChange,
    showValue: true,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.infra.legendControls.reverseDirectionLabel', {
      defaultMessage: 'Reverse direction'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    showLabel: false,
    name: "reverseColors",
    label: _i18n.i18n.translate('xpack.infra.legendControls.euiSwitch.reversecolorsLabel', {
      defaultMessage: 'Reverse colors direction'
    }),
    checked: draftLegend.reverseColors,
    onChange: handleReverseColors,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.infra.legendControls.switchLabel', {
      defaultMessage: 'Auto calculate range'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    showLabel: false,
    name: "bounds",
    label: _i18n.i18n.translate('xpack.infra.legendControls.euiSwitch.boundsLabel', {
      defaultMessage: 'Auto calculate range'
    }),
    checked: draftAuto,
    onChange: handleAutoChange,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_color_label.ColorLabel, {
      paletteSelected: draftLegend.palette,
      color: (0, _lodash.first)(paletteColors),
      label: _i18n.i18n.translate('xpack.infra.legendControls.minLabel', {
        defaultMessage: 'Minimum'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 13
      }
    }),
    isInvalid: !boundsValidRange,
    display: "columnCompressed",
    error: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: 150
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "infraLegendControlsFieldNumber",
    disabled: draftAuto,
    step: 1,
    value: isNaN(draftBounds.min) ? '' : draftBounds.min,
    isInvalid: !boundsValidRange,
    name: "legendMin",
    onChange: handleMinBounds,
    append: "%",
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: /*#__PURE__*/_react.default.createElement(_color_label.ColorLabel, {
      paletteSelected: draftLegend.palette,
      color: (0, _lodash.last)(paletteColors),
      label: _i18n.i18n.translate('xpack.infra.legendControls.maxLabel', {
        defaultMessage: 'Maximum'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 13
      }
    }),
    isInvalid: !boundsValidRange,
    error: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: 150
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "infraLegendControlsFieldNumber",
    disabled: draftAuto,
    step: 1,
    isInvalid: !boundsValidRange,
    value: isNaN(draftBounds.max) ? '' : draftBounds.max,
    name: "legendMax",
    onChange: handleMaxBounds,
    append: "%",
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.legendControls.cancelButton.ariaLabel', {
      defaultMessage: 'Cancel'
    }),
    "data-test-subj": "infraLegendControlsCancelButton",
    type: "submit",
    size: "s",
    onClick: handleCancelClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.legendControls.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    size: "s",
    fill: true,
    disabled: commited || !boundsValidRange,
    onClick: handleApplyClick,
    "data-test-subj": "applyLegendControlsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.legendControls.applyButton",
    defaultMessage: "Apply",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 15
    }
  }))))));
};
exports.LegendControls = LegendControls;
const StyledEuiForm = (0, _styled.default)(_eui.EuiForm)`
  min-width: 400px;
  @media (max-width: 480px) {
    min-width: 100%;
    max-width: 100%;
    width: 100vw;
  }
`;