"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsPageContent = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _constants = require("@kbn/deeplinks-management/constants");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _rison = require("@kbn/rison");
var _common = require("@kbn/logs-shared-plugin/common");
var _log_threshold = require("../../alerting/log_threshold");
var _help_center_content = require("../../components/help_center_content");
var _use_readonly_badge = require("../../hooks/use_readonly_badge");
var _header_action_menu_provider = require("../../containers/header_action_menu_provider");
var _redirect_with_query_params = require("../../utils/redirect_with_query_params");
var _ = require("../404");
var _routes = require("./routes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/page_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogEntryCategoriesPage = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./log_entry_categories'))).then(mod => ({
  default: mod.LogEntryCategoriesPage
})));
const LogEntryRatePage = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./log_entry_rate'))).then(mod => ({
  default: mod.LogEntryRatePage
})));
const LogsPageContent = () => {
  var _uiCapabilities$logs;
  const {
    application,
    share
  } = (0, _public.useKibana)().services;
  const uiCapabilities = application === null || application === void 0 ? void 0 : application.capabilities;
  const onboardingLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const managementLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_constants.MANAGEMENT_APP_LOCATOR);
  const {
    setHeaderActionMenu,
    theme$
  } = (0, _react.useContext)(_header_action_menu_provider.HeaderActionMenuContext);
  (0, _use_readonly_badge.useReadOnlyBadge)(!(uiCapabilities !== null && uiCapabilities !== void 0 && (_uiCapabilities$logs = uiCapabilities.logs) !== null && _uiCapabilities$logs !== void 0 && _uiCapabilities$logs.save));
  const routes = (0, _routes.getLogsAppRoutes)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_help_center_content.HelpCenterContent, {
    feedbackLink: feedbackLinkUrl,
    appName: pageTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), setHeaderActionMenu && theme$ && /*#__PURE__*/_react.default.createElement(_public2.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_log_threshold.LazyAlertDropdownWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    href: onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.useUrl({
      category: 'host'
    }),
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 17
    }
  }, ADD_DATA_LABEL))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/stream",
    exact: true,
    render: props => {
      var _share$url$locators$g;
      const searchParams = new URLSearchParams(props.location.search);
      const logFilterEncoded = searchParams.get('logFilter');
      let locatorParams = {};
      if (logFilterEncoded) {
        const logFilter = (0, _rison.safeDecode)(logFilterEncoded);
        locatorParams = {
          timeRange: logFilter === null || logFilter === void 0 ? void 0 : logFilter.timeRange,
          query: logFilter === null || logFilter === void 0 ? void 0 : logFilter.query,
          filters: logFilter === null || logFilter === void 0 ? void 0 : logFilter.filters
        };
      }
      (_share$url$locators$g = share.url.locators.get(_common.LOGS_LOCATOR_ID)) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.navigate(locatorParams);
      return null;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: routes.logsAnomalies.path,
    component: LogEntryRatePage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: routes.logsCategories.path,
    component: LogEntryCategoriesPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: '/analysis',
    to: routes.logsAnomalies.path,
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: '/log-rate',
    to: routes.logsAnomalies.path,
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: '/',
    to: routes.logsAnomalies.path,
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/settings",
    exact: true,
    render: () => {
      managementLocator === null || managementLocator === void 0 ? void 0 : managementLocator.navigate({
        sectionId: 'kibana',
        appId: 'settings?query=observability%3AlogSources'
      });
      return null;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => /*#__PURE__*/_react.default.createElement(_.NotFoundPage, {
      title: pageTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 30
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })));
};
exports.LogsPageContent = LogsPageContent;
const pageTitle = _i18n.i18n.translate('xpack.infra.header.logsTitle', {
  defaultMessage: 'Logs'
});
const feedbackLinkUrl = 'https://discuss.elastic.co/c/logs';
const ADD_DATA_LABEL = _i18n.i18n.translate('xpack.infra.logsHeaderAddDataButtonLabel', {
  defaultMessage: 'Add data'
});