"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopCategoriesTable = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useSet = _interopRequireDefault(require("react-use/lib/useSet"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _log_analysis = require("../../../../../../common/log_analysis");
var _basic_table = require("../../../../../components/basic_table");
var _anomaly_severity_indicator_list = require("./anomaly_severity_indicator_list");
var _category_details_row = require("./category_details_row");
var _category_expression = require("../../../../../components/logging/log_analysis_results/category_expression");
var _datasets_action_list = require("./datasets_action_list");
var _datasets_list = require("./datasets_list");
var _log_entry_count_sparkline = require("./log_entry_count_sparkline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/sections/top_categories/top_categories_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TopCategoriesTable = exports.TopCategoriesTable = (0, _styled.default)(({
  categorizationJobId,
  className,
  logViewReference,
  timeRange,
  topCategories,
  sortOptions,
  changeSortOptions
}) => {
  const tableSortOptions = (0, _react.useMemo)(() => {
    return {
      sort: sortOptions
    };
  }, [sortOptions]);
  const handleTableChange = (0, _react.useCallback)(({
    sort
  }) => {
    if (_log_analysis.categoriesSortRT.is(sort)) {
      changeSortOptions(sort);
    }
  }, [changeSortOptions]);
  const [expandedCategories, {
    add: expandCategory,
    remove: collapseCategory
  }] = (0, _useSet.default)(new Set());
  const columns = (0, _react.useMemo)(() => createColumns(timeRange, categorizationJobId, expandedCategories, expandCategory, collapseCategory), [categorizationJobId, collapseCategory, expandCategory, expandedCategories, timeRange]);
  const expandedRowContentsById = (0, _react.useMemo)(() => [...expandedCategories].reduce((aggregatedCategoryRows, categoryId) => ({
    ...aggregatedCategoryRows,
    [categoryId]: /*#__PURE__*/_react.default.createElement(_category_details_row.CategoryDetailsRow, {
      categoryId: categoryId,
      logViewReference: logViewReference,
      timeRange: timeRange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    })
  }), {}), [expandedCategories, logViewReference, timeRange]);
  const tableCaption = topCategories.length === 0 ? _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.noCategoriesTableCaption', {
    defaultMessage: 'Table has no data'
  }) : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    itemIdToExpandedRowMap: expandedRowContentsById,
    itemId: "categoryId",
    items: topCategories,
    rowProps: {
      className: `${className} euiTableRow--topAligned`
    },
    onChange: handleTableChange,
    sorting: tableSortOptions,
    tableCaption: tableCaption,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  });
})`
  &.euiTableRow--topAligned .euiTableRowCell {
    vertical-align: top;
  }
`;
const createColumns = (timeRange, categorizationJobId, expandedCategories, expandCategory, collapseCategory) => [{
  align: 'right',
  field: 'logEntryCount',
  name: _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.countColumnTitle', {
    defaultMessage: 'Message count'
  }),
  sortable: true,
  render: logEntryCount => {
    return (0, _numeral.default)(logEntryCount).format('0,0');
  },
  width: '120px'
}, {
  field: 'histograms',
  name: _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.trendColumnTitle', {
    defaultMessage: 'Trend'
  }),
  render: (histograms, item) => {
    return /*#__PURE__*/_react.default.createElement(_log_entry_count_sparkline.LogEntryCountSparkline, {
      currentCount: item.logEntryCount,
      histograms: histograms,
      timeRange: timeRange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    });
  },
  width: '220px'
}, {
  field: 'regularExpression',
  name: _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.categoryColumnTitle', {
    defaultMessage: 'Category'
  }),
  truncateText: true,
  render: regularExpression => /*#__PURE__*/_react.default.createElement(_category_expression.RegularExpressionRepresentation, {
    regularExpression: regularExpression,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  })
}, {
  field: 'datasets',
  name: _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.datasetColumnTitle', {
    defaultMessage: 'Datasets'
  }),
  render: datasets => /*#__PURE__*/_react.default.createElement(_datasets_list.DatasetsList, {
    datasets: datasets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 54
    }
  }),
  width: '200px'
}, {
  align: 'right',
  field: 'maximumAnomalyScore',
  name: _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.maximumAnomalyScoreColumnTitle', {
    defaultMessage: 'Maximum anomaly score'
  }),
  sortable: true,
  render: (_maximumAnomalyScore, item) => /*#__PURE__*/_react.default.createElement(_anomaly_severity_indicator_list.AnomalySeverityIndicatorList, {
    datasets: item.datasets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }),
  width: '160px'
}, {
  actions: [{
    render: category => /*#__PURE__*/_react.default.createElement(_datasets_action_list.DatasetActionsList, {
      categorizationJobId: categorizationJobId,
      categoryId: category.categoryId,
      datasets: category.datasets,
      timeRange: timeRange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 11
      }
    })
  }],
  width: '40px'
}, {
  align: 'right',
  isExpander: true,
  render: item => {
    return /*#__PURE__*/_react.default.createElement(_basic_table.RowExpansionButton, {
      isExpanded: expandedCategories.has(item.categoryId),
      item: item.categoryId,
      onCollapse: collapseCategory,
      onExpand: expandCategory,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 9
      }
    });
  },
  width: '40px'
}];