"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedViewsNotifier = void 0;
var _i18n = require("@kbn/i18n");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSavedViewsNotifier = () => {
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const deleteViewFailure = message => {
    notifications.toasts.addDanger({
      toastLifeTimeMs: 3000,
      title: message || _i18n.i18n.translate('xpack.infra.savedView.errorOnDelete.title', {
        defaultMessage: `An error occurred deleting the view.`
      })
    });
  };
  const getViewFailure = message => {
    notifications.toasts.addDanger({
      toastLifeTimeMs: 3000,
      title: message || _i18n.i18n.translate('xpack.infra.savedView.findError.title', {
        defaultMessage: `An error occurred while loading views.`
      })
    });
  };
  const upsertViewFailure = message => {
    notifications.toasts.addDanger({
      toastLifeTimeMs: 3000,
      title: message || _i18n.i18n.translate('xpack.infra.savedView.errorOnCreate.title', {
        defaultMessage: `An error occurred saving view.`
      })
    });
  };
  return {
    deleteViewFailure,
    getViewFailure,
    upsertViewFailure
  };
};
exports.useSavedViewsNotifier = useSavedViewsNotifier;