"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogAnalysisModuleConfiguration = exports.isJobConfigurationOutdated = void 0;
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogAnalysisModuleConfiguration = ({
  moduleDescriptor,
  sourceConfiguration
}) => {
  const getIsJobConfigurationOutdated = (0, _react.useMemo)(() => isJobConfigurationOutdated(moduleDescriptor, sourceConfiguration), [sourceConfiguration, moduleDescriptor]);
  return {
    getIsJobConfigurationOutdated
  };
};
exports.useLogAnalysisModuleConfiguration = useLogAnalysisModuleConfiguration;
const isJobConfigurationOutdated = ({
  bucketSpan
}, currentSourceConfiguration) => jobSummary => {
  var _jobSummary$fullJob$d;
  if (!jobSummary.fullJob || !jobSummary.fullJob.custom_settings || !jobSummary.fullJob.datafeed_config) {
    return false;
  }
  const jobConfiguration = jobSummary.fullJob.custom_settings.logs_source_config;
  const datafeedRuntimeMappings = (_jobSummary$fullJob$d = jobSummary.fullJob.datafeed_config.runtime_mappings) !== null && _jobSummary$fullJob$d !== void 0 ? _jobSummary$fullJob$d : {};
  return !(jobConfiguration && jobConfiguration.bucketSpan === bucketSpan && jobConfiguration.indexPattern && isSubset(new Set(jobConfiguration.indexPattern.split(',')), new Set(currentSourceConfiguration.indices)) && jobConfiguration.timestampField === currentSourceConfiguration.timestampField && (0, _fastDeepEqual.default)(datafeedRuntimeMappings, currentSourceConfiguration.runtimeMappings));
};
exports.isJobConfigurationOutdated = isJobConfigurationOutdated;
const isSubset = (subset, superset) => {
  return Array.from(subset).every(subsetElement => superset.has(subsetElement));
};