"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callGetLatestCategoriesDatasetsStatsAPI = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _http_api = require("../../../../../common/http_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callGetLatestCategoriesDatasetsStatsAPI = async ({
  jobIds,
  startTime,
  endTime,
  includeCategorizerStatuses
}, fetch) => {
  const response = await fetch(_http_api.LOG_ANALYSIS_GET_LATEST_LOG_ENTRY_CATEGORY_DATASETS_STATS_PATH, {
    method: 'POST',
    body: JSON.stringify(_http_api.getLatestLogEntryCategoryDatasetsStatsRequestPayloadRT.encode({
      data: {
        jobIds,
        timeRange: {
          startTime,
          endTime
        },
        includeCategorizerStatuses
      }
    })),
    version: '1'
  });
  return (0, _ioTsUtils.decodeOrThrow)(_http_api.getLatestLogEntryCategoryDatasetsStatsSuccessResponsePayloadRT)(response);
};
exports.callGetLatestCategoriesDatasetsStatsAPI = callGetLatestCategoriesDatasetsStatsAPI;