"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _empty_states = require("../../empty_states");
var _source_error_page = require("../../source_error_page");
var _metrics_source = require("../../../containers/metrics_source");
var _use_kibana = require("../../../hooks/use_kibana");
var _error_callout = require("../../error_callout");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _no_data_config = require("./no_data_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/shared/templates/infra_page_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InfraPageTemplate = ({
  'data-test-subj': _dataTestSubj,
  dataSourceAvailability,
  onboardingFlow,
  ...pageTemplateProps
}) => {
  var _source$status;
  const {
    services: {
      observabilityAIAssistant,
      observabilityShared: {
        navigation: {
          PageTemplate
        }
      },
      share,
      docLinks
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    source,
    error: sourceError,
    loadSource,
    isLoading: isSourceLoading
  } = (0, _metrics_source.useSourceContext)();
  const {
    error: dataViewLoadError,
    refetch: loadDataView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    remoteClustersExist
  } = (_source$status = source === null || source === void 0 ? void 0 : source.status) !== null && _source$status !== void 0 ? _source$status : {};
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    if (!onboardingFlow) return;
    return await callApi('/api/metrics/source/hasData', {
      method: 'GET',
      query: {
        source: dataSourceAvailability
      }
    });
  }, [onboardingFlow, dataSourceAvailability]);
  const hasData = !!(data !== null && data !== void 0 && data.hasData);
  const noDataConfig = (0, _no_data_config.getNoDataConfig)({
    hasData,
    loading: (0, _use_fetcher.isPending)(status),
    onboardingFlow,
    docsLink: docLinks.links.observability.guide,
    locators: share.url.locators
  });
  const {
    setScreenContext
  } = (observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service) || {};
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      data: [{
        name: 'Metrics configuration',
        value: source,
        description: 'The configuration of the Metrics app'
      }],
      starterPrompts: [...(!hasData ? [{
        title: _i18n.i18n.translate('xpack.infra.metrics.aiAssistant.starterPrompts.explainNoData.title', {
          defaultMessage: 'Explain'
        }),
        prompt: _i18n.i18n.translate('xpack.infra.metrics.aiAssistant.starterPrompts.explainNoData.prompt', {
          defaultMessage: "Why don't I see any data?"
        }),
        icon: 'sparkles'
      }] : [])]
    });
  }, [hasData, setScreenContext, source]);
  if (sourceError) {
    return /*#__PURE__*/_react.default.createElement(_source_error_page.SourceErrorPage, {
      errorMessage: sourceError,
      retry: loadSource,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 12
      }
    });
  }
  if (!isSourceLoading && !remoteClustersExist) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.NoRemoteCluster, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 12
      }
    });
  }
  if (dataViewLoadError) {
    var _source$configuration;
    /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
      error: dataViewLoadError,
      titleOverride: _i18n.i18n.translate('xpack.infra.hostsViewPage.errorOnCreateOrLoadDataviewTitle', {
        defaultMessage: 'Error creating Data View'
      }),
      messageOverride: _i18n.i18n.translate('xpack.infra.hostsViewPage.errorOnCreateOrLoadDataview', {
        defaultMessage: 'There was an error trying to create a Data View: {metricAlias}. Try reloading the page.',
        values: {
          metricAlias: (_source$configuration = source === null || source === void 0 ? void 0 : source.configuration.metricAlias) !== null && _source$configuration !== void 0 ? _source$configuration : ''
        }
      }),
      onTryAgainClick: loadDataView,
      hasTryAgainButton: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 5
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(PageTemplate, (0, _extends2.default)({
    "data-test-subj": hasData ? _dataTestSubj : 'noDataPage',
    noDataConfig: noDataConfig
  }, pageTemplateProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }));
};
exports.InfraPageTemplate = InfraPageTemplate;