"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addMetricsCalloutDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _no_data_config = require("../../shared/templates/no_data_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultPrimaryActionLabel = _i18n.i18n.translate('xpack.infra.addDataCallout.hostOverviewPrimaryActionLabel', {
  defaultMessage: 'Add Metrics'
});
const defaultContent = {
  content: {
    title: _i18n.i18n.translate('xpack.infra.addDataCallout.defaultTitle', {
      defaultMessage: 'View core metrics to understand your host performance'
    }),
    content: _i18n.i18n.translate('xpack.infra.addDataCallout.defaultContent', {
      defaultMessage: 'Collect metrics such as CPU and memory usage to identify performance bottlenecks that could be affecting your users.'
    })
  }
};
const hostDefaultActions = locator => {
  return {
    actions: {
      primary: {
        href: locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
          category: _no_data_config.OnboardingFlow.Hosts
        }),
        label: defaultPrimaryActionLabel
      },
      secondary: {
        href: 'https://ela.st/demo-cluster-hosts'
      },
      link: {
        href: 'https://ela.st/docs-hosts-add-metrics'
      }
    }
  };
};
const containerDefaultActions = locator => {
  return {
    actions: {
      primary: {
        href: locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
          category: _no_data_config.OnboardingFlow.Hosts
        }),
        label: defaultPrimaryActionLabel
      },
      link: {
        href: 'https://ela.st/docs-containers-add-metrics'
      }
    }
  };
};
const addMetricsCalloutDefinitions = locator => {
  return {
    hostOverview: {
      ...defaultContent,
      ...hostDefaultActions(locator)
    },
    hostMetrics: {
      ...defaultContent,
      ...hostDefaultActions(locator)
    },
    hostProcesses: {
      content: {
        title: _i18n.i18n.translate('xpack.infra.addDataCallout.hostProcessesTitle', {
          defaultMessage: 'View host processes to identify performance bottlenecks'
        }),
        content: _i18n.i18n.translate('xpack.infra.addDataCallout.hostProcessesContent', {
          defaultMessage: 'Collect process data to understand what is consuming resource on your hosts.'
        })
      },
      ...hostDefaultActions(locator)
    },
    containerOverview: {
      ...defaultContent,
      ...containerDefaultActions(locator)
    },
    containerMetrics: {
      ...defaultContent,
      ...containerDefaultActions(locator)
    }
  };
};
exports.addMetricsCalloutDefinitions = addMetricsCalloutDefinitions;