"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomEquationEditor = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _http_api = require("../../../../../common/http_api");
var _metrics = require("../../../../../common/alerting/metrics");
var _metric_row_with_agg = require("./metric_row_with_agg");
var _metric_row_with_count = require("./metric_row_with_count");
var _i18n_strings = require("../../i18n_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/metric_threshold/components/custom_equation/custom_equation_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NEW_METRIC = {
  name: 'A',
  aggType: _metrics.Aggregators.AVERAGE
};
const MAX_VARIABLES = 26;
const CHAR_CODE_FOR_A = 65;
const CHAR_CODE_FOR_Z = CHAR_CODE_FOR_A + MAX_VARIABLES;
const VAR_NAMES = (0, _lodash.range)(CHAR_CODE_FOR_A, CHAR_CODE_FOR_Z).map(c => String.fromCharCode(c));
const CustomEquationEditor = ({
  onChange,
  expression,
  fields,
  aggregationTypes,
  errors
}) => {
  var _expression$customMet;
  const [customMetrics, setCustomMetrics] = (0, _react.useState)((_expression$customMet = expression === null || expression === void 0 ? void 0 : expression.customMetrics) !== null && _expression$customMet !== void 0 ? _expression$customMet : [NEW_METRIC]);
  const [label, setLabel] = (0, _react.useState)((expression === null || expression === void 0 ? void 0 : expression.label) || undefined);
  const [equation, setEquation] = (0, _react.useState)((expression === null || expression === void 0 ? void 0 : expression.equation) || undefined);
  const debouncedOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(onChange, 500), [onChange]);
  const handleAddNewRow = (0, _react.useCallback)(() => {
    setCustomMetrics(previous => {
      var _previous$map;
      const currentVars = (_previous$map = previous === null || previous === void 0 ? void 0 : previous.map(m => m.name)) !== null && _previous$map !== void 0 ? _previous$map : [];
      const name = (0, _lodash.first)((0, _lodash.xor)(VAR_NAMES, currentVars));
      const nextMetrics = [...(previous || []), {
        ...NEW_METRIC,
        name
      }];
      debouncedOnChange({
        ...expression,
        customMetrics: nextMetrics,
        equation,
        label
      });
      return nextMetrics;
    });
  }, [debouncedOnChange, equation, expression, label]);
  const handleDelete = (0, _react.useCallback)(name => {
    setCustomMetrics(previous => {
      var _previous$filter;
      const nextMetrics = (_previous$filter = previous === null || previous === void 0 ? void 0 : previous.filter(row => row.name !== name)) !== null && _previous$filter !== void 0 ? _previous$filter : [NEW_METRIC];
      const finalMetrics = nextMetrics.length && nextMetrics || [NEW_METRIC];
      debouncedOnChange({
        ...expression,
        customMetrics: finalMetrics,
        equation,
        label
      });
      return finalMetrics;
    });
  }, [equation, expression, debouncedOnChange, label]);
  const handleChange = (0, _react.useCallback)(metric => {
    setCustomMetrics(previous => {
      const nextMetrics = previous === null || previous === void 0 ? void 0 : previous.map(m => m.name === metric.name ? metric : m);
      debouncedOnChange({
        ...expression,
        customMetrics: nextMetrics,
        equation,
        label
      });
      return nextMetrics;
    });
  }, [equation, expression, debouncedOnChange, label]);
  const handleEquationChange = (0, _react.useCallback)(e => {
    setEquation(e.target.value);
    debouncedOnChange({
      ...expression,
      customMetrics,
      equation: e.target.value,
      label
    });
  }, [debouncedOnChange, expression, customMetrics, label]);
  const handleLabelChange = (0, _react.useCallback)(e => {
    setLabel(e.target.value);
    debouncedOnChange({
      ...expression,
      customMetrics,
      equation,
      label: e.target.value
    });
  }, [debouncedOnChange, expression, customMetrics, equation]);
  const disableAdd = (customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.length) === MAX_VARIABLES;
  const disableDelete = (customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.length) === 1;
  const filteredAggregationTypes = (0, _lodash.omit)(aggregationTypes, _http_api.OMITTED_AGGREGATIONS_FOR_CUSTOM_METRICS);
  const metricRows = customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.map(row => {
    if (row.aggType === _metrics.Aggregators.COUNT) {
      return /*#__PURE__*/_react.default.createElement(_metric_row_with_count.MetricRowWithCount, {
        key: row.name,
        name: row.name,
        agg: row.aggType,
        filter: row.filter,
        onAdd: handleAddNewRow,
        onDelete: handleDelete,
        disableAdd: disableAdd,
        aggregationTypes: filteredAggregationTypes,
        disableDelete: disableDelete,
        onChange: handleChange,
        errors: errors,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_metric_row_with_agg.MetricRowWithAgg, {
      key: row.name,
      name: row.name,
      aggType: row.aggType,
      aggregationTypes: filteredAggregationTypes,
      field: row.field,
      fields: fields,
      onAdd: handleAddNewRow,
      onDelete: handleDelete,
      disableAdd: disableAdd,
      disableDelete: disableDelete,
      onChange: handleChange,
      errors: errors,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    });
  });
  const placeholder = (0, _react.useMemo)(() => {
    return customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.map(row => row.name).join(' + ');
  }, [customMetrics]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), metricRows, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraCustomEquationEditorAddAggregationFieldButton",
    color: 'primary',
    flush: 'left',
    size: "xs",
    iconType: 'plusInCircleFilled',
    onClick: handleAddNewRow,
    isDisabled: disableAdd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.customEquationEditor.addCustomRow",
    defaultMessage: "Add aggregation/field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.equation', {
      defaultMessage: 'Equation'
    }),
    fullWidth: true,
    helpText: _i18n_strings.EQUATION_HELP_MESSAGE,
    isInvalid: errors.equation != null,
    error: [errors.equation],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "infraCustomEquationEditorFieldText",
    isInvalid: errors.equation != null,
    compressed: true,
    fullWidth: true,
    placeholder: placeholder,
    onChange: handleEquationChange,
    value: equation !== null && equation !== void 0 ? equation : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n_strings.LABEL_LABEL,
    fullWidth: true,
    helpText: _i18n_strings.LABEL_HELP_MESSAGE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "infraCustomEquationEditorFieldText",
    compressed: true,
    fullWidth: true,
    value: label,
    placeholder: _i18n_strings.CUSTOM_EQUATION,
    onChange: handleLabelChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  })))));
};
exports.CustomEquationEditor = CustomEquationEditor;