"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const suggestions = [keywords => {
  if (keywords.includes('STATS') && keywords.includes('DATE_TRUNC')) {
    return ['BUCKET'];
  }
}, keywords => {
  if (keywords.includes('TO_DATETIME')) {
    return ['DATE_PARSE'];
  }
}];

/**
 * Based on the list of keywords the model asked to get documentation for,
 * Try to provide suggestion on other commands or keywords that may be useful.
 *
 * E.g. when requesting documentation for `STATS` and `DATE_TRUNC`, suggests `BUCKET`
 *
 */
const getSuggestions = keywords => {
  return suggestions.reduce((list, sugg) => {
    var _sugg;
    list.push(...((_sugg = sugg(keywords)) !== null && _sugg !== void 0 ? _sugg : []));
    return list;
  }, []);
};
exports.getSuggestions = getSuggestions;