"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chunkFromOpenAI = chunkFromOpenAI;
exports.tokenCountFromOpenAI = tokenCountFromOpenAI;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function chunkFromOpenAI(chunk) {
  var _delta$content, _delta$refusal, _delta$tool_calls$map, _delta$tool_calls;
  const delta = chunk.choices[0].delta;
  return {
    type: _inferenceCommon.ChatCompletionEventType.ChatCompletionChunk,
    content: (_delta$content = delta.content) !== null && _delta$content !== void 0 ? _delta$content : '',
    refusal: (_delta$refusal = delta.refusal) !== null && _delta$refusal !== void 0 ? _delta$refusal : undefined,
    tool_calls: (_delta$tool_calls$map = (_delta$tool_calls = delta.tool_calls) === null || _delta$tool_calls === void 0 ? void 0 : _delta$tool_calls.map(toolCall => {
      var _toolCall$function$na, _toolCall$function, _toolCall$function$ar, _toolCall$function2, _toolCall$id;
      return {
        function: {
          name: (_toolCall$function$na = (_toolCall$function = toolCall.function) === null || _toolCall$function === void 0 ? void 0 : _toolCall$function.name) !== null && _toolCall$function$na !== void 0 ? _toolCall$function$na : '',
          arguments: (_toolCall$function$ar = (_toolCall$function2 = toolCall.function) === null || _toolCall$function2 === void 0 ? void 0 : _toolCall$function2.arguments) !== null && _toolCall$function$ar !== void 0 ? _toolCall$function$ar : ''
        },
        toolCallId: (_toolCall$id = toolCall.id) !== null && _toolCall$id !== void 0 ? _toolCall$id : '',
        index: toolCall.index
      };
    })) !== null && _delta$tool_calls$map !== void 0 ? _delta$tool_calls$map : []
  };
}
function tokenCountFromOpenAI(completionUsage, model) {
  var _completionUsage$prom;
  return {
    type: _inferenceCommon.ChatCompletionEventType.ChatCompletionTokenCount,
    tokens: {
      completion: completionUsage.completion_tokens,
      prompt: completionUsage.prompt_tokens,
      total: completionUsage.total_tokens,
      cached: (_completionUsage$prom = completionUsage.prompt_tokens_details) === null || _completionUsage$prom === void 0 ? void 0 : _completionUsage$prom.cached_tokens
    },
    ...(model ? {
      model
    } : {})
  };
}