"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseRuleSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean()
});
const regexRuleSchema = _configSchema.schema.allOf([baseRuleSchema, _configSchema.schema.object({
  type: _configSchema.schema.literal('RegExp'),
  pattern: _configSchema.schema.string(),
  entityClass: _configSchema.schema.string()
})]);
const nerRuleSchema = _configSchema.schema.allOf([baseRuleSchema, _configSchema.schema.object({
  type: _configSchema.schema.literal('NER'),
  modelId: _configSchema.schema.string(),
  allowedEntityClasses: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('PER'), _configSchema.schema.literal('ORG'), _configSchema.schema.literal('LOC'), _configSchema.schema.literal('MISC')]))),
  timeoutSeconds: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1
  }))
})]);
const uiSettings = exports.uiSettings = {
  [_inferenceCommon.aiAnonymizationSettings]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.inference.anonymizationSettingsLabel', {
      defaultMessage: 'Anonymization Settings'
    }),
    value: JSON.stringify({
      rules: [{
        entityClass: 'EMAIL',
        type: 'RegExp',
        pattern: '([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})',
        enabled: false
      }, {
        type: 'NER',
        modelId: 'elastic__distilbert-base-uncased-finetuned-conll03-english',
        enabled: false,
        allowedEntityClasses: ['PER', 'ORG', 'LOC'],
        timeoutSeconds: 30
      }]
    }, null, 2),
    description: _i18n.i18n.translate('xpack.inference.anonymizationSettingsDescription', {
      defaultMessage: `List of anonymization rules
          <ul>
            <li><strong>type:</strong> "ner" or "regex"</li>
            <li><strong>entityClass:</strong> (regex type only) eg: EMAIL, URL, IP</li>
            <li><strong>pattern:</strong> (regex type only) the regular-expression string to match</li>
            <li><strong>modelId:</strong> (ner type only) ID of the NER (Named Entity Recognition) model to use</li>
            <li><strong>enabled:</strong> boolean flag to turn the rule on or off</li>
            <li><strong>timeoutSeconds:</strong> (ner type only) maximum seconds <em>per inference request</em> before timing out (multiple requests may be issued during a single chat interaction)</li>
          </ul>`,
      values: {
        ul: chunks => `<ul>${chunks}</ul>`,
        li: chunks => `<li>${chunks}</li>`,
        strong: chunks => `<strong>${chunks}</strong>`,
        em: chunks => `<em>${chunks}</em>`
      }
    }),
    schema: _configSchema.schema.object({
      rules: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([regexRuleSchema, nerRuleSchema]))
    }),
    type: 'json',
    requiresPageReload: true,
    solutionViews: ['classic', 'oblt'],
    technicalPreview: true
  }
};