"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexMode = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexMode = exports.IndexMode = {
  standard: 'standard',
  logsdb: 'logsdb',
  time_series: 'time_series',
  lookup: 'lookup'
};

/**
 * Interface for the template list returned by Index Management's
 * `GET /api/index_management/index_templates` endpoint.
 *
 * This is a copy of the plugin's TemplateListItem interface with additional fields added during deserialization,
 * kept here to allow cross-plugin consumption without creating cyclic dependencies.
 */