"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCreateRoute = registerCreateRoute;
var _configSchema = require("@kbn/config-schema");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bodySchema = _configSchema.schema.object({
  indexName: _configSchema.schema.string(),
  indexMode: _configSchema.schema.string()
});
function registerCreateRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  router.put({
    path: (0, _.addInternalBasePath)('/indices/create'),
    security: {
      authz: {
        enabled: false,
        reason: 'Relies on es client for authorization'
      }
    },
    validate: {
      body: bodySchema
    }
  }, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    const {
      indexName,
      indexMode
    } = request.body;
    const params = {
      index: indexName,
      settings: {
        mode: indexMode
      }
    };
    try {
      await client.asCurrentUser.indices.create(params);
      return response.ok();
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}