"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseMappings = void 0;
var _lib = require("../components/mappings_editor/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseMappings = value => {
  const mappingsDefinition = (0, _lib.extractMappingsDefinition)(value);
  if (mappingsDefinition === null) {
    return {
      multipleMappingsDeclared: true
    };
  }
  const {
    _source,
    _meta,
    _routing,
    _size,
    dynamic,
    properties,
    runtime,
    numeric_detection,
    date_detection,
    dynamic_date_formats,
    dynamic_templates,
    subobjects
  } = mappingsDefinition;
  const parsed = {
    configuration: {
      _source,
      _meta,
      _routing,
      _size,
      dynamic,
      numeric_detection,
      date_detection,
      dynamic_date_formats,
      subobjects
    },
    fields: properties,
    templates: {
      dynamic_templates
    },
    runtime
  };
  return {
    parsedDefaultValue: parsed,
    multipleMappingsDeclared: false
  };
};
exports.parseMappings = parseMappings;