"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFieldButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_mappings_content/add_field_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddFieldButton = ({
  hasUpdateMappingsPrivilege,
  color,
  addFieldButtonOnClick
}) => {
  const isDisabled = hasUpdateMappingsPrivilege === false;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    "data-test-subj": "indexDetailsMappingsAddFieldTooltip",
    content: isDisabled ? _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.addNewFieldToolTip', {
      defaultMessage: 'You do not have permission to add fields to an index'
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: addFieldButtonOnClick,
    iconType: "plusInCircle",
    color: color,
    size: "m",
    "data-test-subj": "indexDetailsMappingsAddField",
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappings.addNewField",
    defaultMessage: "Add field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  })));
};
exports.AddFieldButton = AddFieldButton;