"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PoliciesTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/enrich_policies_list/policies_table/policies_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PoliciesTable = ({
  policies,
  onReloadClick,
  onDeletePolicyClick,
  onExecutePolicyClick
}) => {
  const {
    history,
    privs
  } = (0, _app_context.useAppContext)();
  const createBtn = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    key: "createPolicy",
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "createPolicyButton"
  }, (0, _public.reactRouterNavigate)(history, '/enrich_policies/create'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicies.table.createPolicyButton",
    defaultMessage: "Create enrich policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
  const toolsRight = [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    key: "reloadPolicies",
    "data-test-subj": "reloadPoliciesButton",
    iconType: "refresh",
    color: "success",
    onClick: onReloadClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicies.table.reloadButton",
    defaultMessage: "Reload",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }))];
  if (privs.manageEnrich) {
    toolsRight.push(createBtn);
  }
  const search = {
    toolsRight,
    box: {
      incremental: true
    }
  };
  const actions = {
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.actionsField', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      isPrimary: true,
      name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.executeAction', {
        defaultMessage: 'Execute'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.executeDescription', {
        defaultMessage: 'Execute this enrich policy'
      }),
      type: 'icon',
      icon: 'play',
      'data-test-subj': 'executePolicyButton',
      onClick: ({
        name
      }) => onExecutePolicyClick(name)
    }, {
      isPrimary: true,
      name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.deleteAction', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.deleteDescription', {
        defaultMessage: 'Delete this enrich policy'
      }),
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      'data-test-subj': 'deletePolicyButton',
      onClick: ({
        name
      }) => onDeletePolicyClick(name)
    }]
  };
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.nameField', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    truncateText: true,
    render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
      "data-test-subj": "enrichPolicyDetailsLink"
    }, (0, _public.reactRouterNavigate)(history, {
      pathname: '/enrich_policies',
      search: `policy=${encodeURIComponent(name)}`
    }), {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }), name)
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.typeField', {
      defaultMessage: 'Type'
    }),
    sortable: true
  }, {
    field: 'sourceIndices',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.sourceIndicesField', {
      defaultMessage: 'Source indices'
    }),
    truncateText: true,
    render: indices => /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 38
      }
    }, indices.join(', '))
  }, {
    field: 'matchField',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.matchFieldField', {
      defaultMessage: 'Match field'
    }),
    truncateText: true
  }, {
    field: 'enrichFields',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.enrichFieldsField', {
      defaultMessage: 'Enrich fields'
    }),
    truncateText: true,
    render: fields => /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 37
      }
    }, fields.join(', '))
  }];
  if (privs.manageEnrich) {
    columns.push(actions);
  }
  const {
    pageSize,
    sorting,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'enrichPolicies',
    initialPageSize: 50,
    initialSort: {
      field: 'name',
      direction: 'asc'
    }
  });
  const pagination = {
    pageSize,
    pageSizeOptions: _sharedUxTablePersist.DEFAULT_PAGE_SIZE_OPTIONS
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "enrichPoliciesTable",
    items: policies,
    itemId: "name",
    columns: columns,
    search: search,
    pagination: pagination,
    sorting: sorting,
    onTableChange: onTableChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  });
};
exports.PoliciesTable = PoliciesTable;