"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nLoader = exports.i18n = void 0;
var _core = require("./src/core");
var _loader = require("./src/loader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const i18n = exports.i18n = {
  getTranslation: _core.getTranslation,
  getLocale: _core.getLocale,
  translate: _core.translate,
  formatList: _core.formatList,
  init: _core.init,
  load: _core.load,
  handleIntlError: _core.handleIntlError,
  getIsInitialized: _core.getIsInitialized
};
const i18nLoader = exports.i18nLoader = {
  registerTranslationFile: _loader.registerTranslationFile,
  registerTranslationFiles: _loader.registerTranslationFiles,
  getTranslationsByLocale: _loader.getTranslationsByLocale,
  getAllTranslations: _loader.getAllTranslations,
  getAllTranslationsFromPaths: _loader.getAllTranslationsFromPaths,
  getRegisteredLocales: _loader.getRegisteredLocales
};