"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatExperience = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _ai_agent_confirmation_modal = require("@kbn/ai-agent-confirmation-modal/ai_agent_confirmation_modal");
var _get_is_ai_agents_enabled = require("@kbn/ai-assistant-common/src/utils/get_is_ai_agents_enabled");
var _settings_context = require("../../contexts/settings_context");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/components/chat_experience/chat_experience.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChatExperience = () => {
  var _application$capabili;
  const {
    fields,
    handleFieldChange,
    unsavedChanges
  } = (0, _settings_context.useSettingsContext)();
  const {
    services: {
      settings,
      notifications,
      docLinks,
      application,
      featureFlags
    }
  } = (0, _use_kibana.useKibana)();
  const [isConfirmModalOpen, setConfirmModalOpen] = (0, _react.useState)(false);
  const isAiAgentsEnabled = (0, _get_is_ai_agents_enabled.getIsAiAgentsEnabled)(featureFlags);
  const field = fields[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE];
  const canEditAdvancedSettings = Boolean((_application$capabili = application.capabilities.advancedSettings) === null || _application$capabili === void 0 ? void 0 : _application$capabili.save);
  const wrappedHandleFieldChange = (0, _react.useCallback)((id, change) => {
    if (id === _managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE && (change === null || change === void 0 ? void 0 : change.unsavedValue) === _aiAssistantCommon.AIChatExperience.Agent) {
      setConfirmModalOpen(true);
    }
    handleFieldChange(id, change);
  }, [handleFieldChange]);
  const handleConfirmAgent = () => {
    setConfirmModalOpen(false);
  };
  const handleCancelAgent = (0, _react.useCallback)(() => {
    setConfirmModalOpen(false);
    // Clear the unsaved change by passing undefined
    handleFieldChange(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE, undefined);
  }, [handleFieldChange]);
  const description = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "aiAssistantManagementSelection.preferredChatExperienceSettingDescription",
    defaultMessage: "Choose which chat experience to use for everyone in this space. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.agentBuilder.learnMore,
        target: "_blank",
        "data-test-subj": "aiAgentBuilderLearnMoreLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "aiAssistantManagementSelection.preferredChatExperienceSettingDescription.learnMoreLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), [docLinks.links.agentBuilder.learnMore]);
  if (!isAiAgentsEnabled || !field) {
    return null;
  }
  const fieldWithDescription = {
    ...field,
    description
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
    links: docLinks.links.management,
    showDanger: message => notifications.toasts.addDanger(message),
    validateChange: (key, value) => settings.client.validateValue(key, value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRow, {
    field: fieldWithDescription,
    isSavingEnabled: canEditAdvancedSettings,
    onFieldChange: wrappedHandleFieldChange,
    unsavedChange: unsavedChanges[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  })), isConfirmModalOpen && /*#__PURE__*/_react.default.createElement(_ai_agent_confirmation_modal.AIAgentConfirmationModal, {
    onConfirm: handleConfirmAgent,
    onCancel: handleCancelAgent,
    docLinks: docLinks.links,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }));
};
exports.ChatExperience = ChatExperience;